% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/toRR.r
\name{toRR}
\alias{toRR}
\title{Display count model coefficient table as incidence rate ratios and associated statistics.}
\format{\describe{
\item{object}{
The only argument is the name of the fitted glm or glm.nb function model}

\item{or}{incidence rate ratio of predictor}
\item{delta}{Model standard error using delta method}
\item{zscore}{z-statistic}
\item{pvalue}{probability-value based on normal distribution}
\item{exp.loci}{Exponentialed lower model confidence interval}
\item{exp.upci}{Expontiated upper model confidence interval}
}}
\usage{
toRR(object)
}
\arguments{
\item{object}{name of the fitted glm function model}
}
\value{
list
}
\description{
Following the glm or glm.nb commands, toRR() displays a table of incidence rate ratios and related statistics
including exponentiated model confidence intervals.
}
\details{
toRR is a post-estimation function, following the use of glm() with the Poisson
or negative.binomial families, and following glm.nb().
}
\note{
toRR must be loaded into memory in order to be effectve. As a function in LOGIT,
it is immediately available to a user.
}
\examples{
library(MASS)
library(LOGIT)
data(medpar)
medpar$los<-as.numeric(medpar$los)
mypoi <- glm(los ~ white + hmo + factor(age80), family=poisson, data=medpar)
summary(mypoi)
toRR(mypoi)
}
\author{
Joseph M. Hilbe, Arizona State University, and
Jet Propulsion Laboratory, California Institute of technology
}
\references{
Hilbe, Joseph M. (2015), Practical Guide to Logistic Regression, Chapman & Hall/CRC.

Hilbe, Joseph M. (2014), Modeling Count Data, Cambridge University Press.
}
\seealso{
\code{\link{glm}}, \code{\link{glm.nb}}
}
\keyword{models}

