% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TDA.R
\name{pssk}
\alias{pssk}
\title{pssk}
\usage{
pssk(Dg1 = NULL, Dg2 = NULL, sigma = NULL, dimensions = NULL)
}
\arguments{
\item{Dg1}{a persistence diagram as a n1 x 3 matrix where each row is a topological feature
and the columns are dimension, birth and death of the feature.}

\item{Dg2}{another persistence diagram as a n2 x 3 matrix}

\item{sigma}{kernel bandwidth}

\item{dimensions}{vector of the dimensions of the topological features to consider, if NULL (default) use all available dimensions}
}
\value{
kernel value
}
\description{
Compute the persistence scale-space kernel on persistence diagrams. 
Reference: Jan Reininghaus, Stefan Huber, Ulrich Bauer, and Roland Kwitt. A stable multi-scale kernel for topological machine learning. In Proceedings of the IEEE conference on computer vision and pattern recognition (CVPR), pages 4741–4748, 2015.
}
\examples{
D1 <- matrix(c(0,0,0,1,1,0,0,0,1.5, 3.5,2,2.5,3, 4, 6), ncol = 3, byrow = FALSE)
D2 <- matrix(c(0,0,1,1,0, 0, 1.2, 2, 1.4, 3.2,4.6,6.5), ncol = 3, byrow = FALSE)
K <- pssk(Dg1 = D1, Dg2 = D2, sigma = 1)
}
