% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_tests.R
\name{beta_shape1_lr_test}
\alias{beta_shape1_lr_test}
\title{Test the shape1 parameter of a beta distribution using the likelihood ratio test.}
\source{
\url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
}
\usage{
beta_shape1_lr_test(x, shape1, alternative = "two.sided", conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of at least 50 data values.}

\item{shape1}{a number indicating the tested value of the shape1 parameter.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the shape1 parameter of a beta distribution using the likelihood ratio test.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rbeta(100, shape1 = 1, shape2 = 2)
beta_shape1_lr_test(x, 1, "two.sided")

# Null is false
set.seed(1)
x <- rbeta(100, shape1 = 3, shape2 = 2)
beta_shape1_lr_test(x, 1, "greater")
}
