% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_tests.R
\name{gamma_shape_one_way}
\alias{gamma_shape_one_way}
\title{Test the equality of shape parameters of gamma distributions.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
gamma_shape_one_way(x, fctr, conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of at least 50 data values per group.}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test the equality of shape parameters of gamma distributions.
}
\details{
\itemize{
\item Null: All shapes are equal. (shape_1 = shape_2 ... shape_k).
\item Alternative: At least one shape is not equal.
}
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rgamma(150, 2, 2)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
gamma_shape_one_way(x, fctr, .95)

# Null is false
set.seed(1)
x <- c(rgamma(50, 1, 2), rgamma(50, 2, 2), rgamma(50, 3, 2))
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
gamma_shape_one_way(x, fctr, .95)
}
