% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Framingham.R
\docType{data}
\name{Framingham}
\alias{Framingham}
\title{Data from the Framingham heart study}
\format{
4238 rows, each of which is a FHS subject. There are 16 variables:
\itemize{
\item \code{sex}
\item \code{age} of the patient
\item \code{education} highest level achieved: some HS, HS grad/GED, some college/vocational school, college graduate
\item \code{currentSmoker}: whether or not the patient is a current smoker
\item \code{cigsPerDay}: the number of cigarettes that the person smoked on average in one day.
\item \code{BPMeds}: whether or not the patient was on blood pressure medication
\item \code{prevalentStroke}: whether or not the patient had previously had a stroke
\item \code{prevalentHyp}: whether or not the patient was hypertensive
\item \code{diabetes}: whether or not the patient had diabetes
\item \code{totChol}: total cholesterol level
\item \code{sysBP}: systolic blood pressure
\item \code{diaBP}: diastolic blood pressure
\item \code{BMI}: Body Mass Index
\item \code{heartRate}: heart rate
\item \code{glucose}: glucose level
\item \code{TenYearCHD}: Did the patient develop congestive heart disease during a 10 year follow-up? (1=Yes)
}
}
\source{
\href{https://www.kaggle.com/datasets/dileep070/heart-disease-prediction-using-logistic-regression}{Kaggle} and \href{https://github.com/GauravPadawe/Framingham-Heart-Study}{Github repository}
}
\usage{
data(Framingham)
}
\description{
When it launched in 1948 the original goal of The Framingham Heart Study (FHS) launched in 1948
with the goal of identifying risk factors for cardiovascular disease. FHS had over 14,000 people from three generations,
including the original participants, their children, and their grandchildren. These data represent
4238 Framingham subjects and were published by Kaggle for a machine-learning competition. The goal of
the competition was to predict \code{TenYearCHD} from the other factors.
}
\references{
Description of \href{https://www.nhlbi.nih.gov/science/framingham-heart-study-fhs}{FHS by the National Heart, Lung, and Blood Institute}
}
\keyword{datasets}
