% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{sample}
\alias{sample}
\alias{sample.default}
\alias{resample}
\title{Samples from various kinds of objects}
\usage{
sample(x, n, replace = FALSE, ...)

\method{sample}{default}(
  x,
  n = length(x),
  replace = FALSE,
  prob = NULL,
  .by = NULL,
  groups = .by,
  orig.ids = FALSE,
  ...
)

resample(..., replace = TRUE)
}
\arguments{
\item{x}{The object from which to sample}

\item{n}{Size of the sample.}

\item{replace}{Logical flag: whether to sample with replacement. (default: \code{FALSE})}

\item{prob}{Probabilities to use for sampling, one for each element of \code{x}}

\item{.by}{Variables to use to define groups for sampling, as in \code{{dplyr}}. The sample size
applies to each group.}

\item{groups}{Variable indicating blocks to sample within}

\item{orig.ids}{Logical. If \code{TRUE}, append a column named "orig.ids" with the
row from the original \code{x} that the same came from.}

\item{\ldots}{Arguments to pass along to specific sample methods.}
}
\value{
A vector or a data frame depending on the nature of the \code{x} argument.
}
\description{
A set of methods to generate random samples from data frames and data simulations.
For data frames, individual rows are sampled. For vectors, elements are sampled.
}
\details{
These are based in spirit on the sample functions in the \code{{mosaic}} package,
but are redefined here to 1) avoid a dependency on \code{{mosaic}} and 2) bring the arguments in
line with the \verb{.by =} features of \code{{dplyr}}.
}
\examples{
sample(sim_03, n=5) # run a simulation
sample(Clock_auction, n = 3) # from a data frame
sample(1:6, n = 6) # sample from a vector

}
