% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel.R
\name{char_keyness}
\alias{char_keyness}
\title{Identify context words using user-provided patterns}
\usage{
char_keyness(
  x,
  pattern,
  valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE,
  window = 10,
  p = 0.001,
  min_count = 10,
  remove_pattern = TRUE,
  ...
)
}
\arguments{
\item{x}{a tokens object created by \code{\link[quanteda:tokens]{quanteda::tokens()}}.}

\item{pattern}{\code{\link[quanteda:pattern]{quanteda::pattern()}} to specify target words}

\item{valuetype}{the type of pattern matching: \code{"glob"} for "glob"-style
wildcard expressions; \code{"regex"} for regular expressions; or \code{"fixed"} for
exact matching. See \code{\link[quanteda:valuetype]{quanteda::valuetype()}} for details.}

\item{case_insensitive}{ignore case when matching, if \code{TRUE}}

\item{window}{size of window for collocation analysis.}

\item{p}{threshold for statistical significance of collocations.}

\item{min_count}{minimum frequency of words within the window to be
considered as collocations.}

\item{remove_pattern}{if \code{TRUE}, keywords do not containe target words.}

\item{...}{additional arguments passed to \code{\link[=textstat_keyness]{textstat_keyness()}}.}
}
\description{
Identify context words using user-provided patterns
}
\examples{
\donttest{
require(quanteda)
con <- url("https://bit.ly/2GZwLcN", "rb")
corp <- readRDS(con)
close(con)
corp <- corpus_reshape(corp, 'sentences')
toks <- tokens(corp, remove_punct = TRUE)
toks <- tokens_remove(toks, stopwords())

# economy keywords
eco <- char_keyness(toks, 'econom*')
head(eco, 20)

# politics keywords
pol <- char_keyness(toks, 'politi*')
head(pol, 20)
}
}
\seealso{
\code{\link[=tokens_select]{tokens_select()}} and \code{\link[=textstat_keyness]{textstat_keyness()}}
}
