% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg_log_l.R
\name{neg_log_l}
\alias{neg_log_l}
\title{The Negative Log-Likelehood Function in \code{LVGP} Package}
\usage{
neg_log_l(hyperparam, p_quant, p_qual, lvs_qual, n_lvs_qual, dim_z,
  X_quant, X_qual, Y, min_eig, k, M)
}
\arguments{
\item{hyperparam}{Hyperparameters of the LVGP model}

\item{p_quant}{Number of quantative variables}

\item{p_qual}{Number of qualitative variables}

\item{lvs_qual}{Levels of each qualitative variable}

\item{n_lvs_qual}{Number of levels of each qualitative variable}

\item{dim_z}{Dimensionality of latent variables, usually 1 or 2}

\item{X_quant}{Input data of quantative variables}

\item{X_qual}{Input data of qualitative variables}

\item{Y}{Vector containing the outputs of data points}

\item{min_eig}{The smallest eigen value that the correlation matrix is allowed to have, which determines the nugget added to the correlation matrix.}

\item{k}{Number of data points, \code{nrow(X_quant)} or \code{nrow(X_qual)}}

\item{M}{Vector of ones with length \code{k}}
}
\value{
The negative log-likelihood (excluding all the constant terms) value.
}
\description{
Calculates the negative log-likelihood (excluding all the constant terms) as described in \code{reference 1}.
}
\details{
\code{\link[LVGP]{LVGP_fit}} calls this function as its optimization objective function.
}
\note{
This function is \strong{NOT} exported once the package is loaded.
}
\examples{
# see the examples in the documentation of the function LVGP_fit.
}
\references{
\enumerate{
\item "A Latent Variable Approach to Gaussian Process Modeling with Qualitative and Quantitative Factors", Yichi Zhang, Siyu Tao, Wei Chen, and Daniel W. Apley (\href{https://arxiv.org/abs/1806.07504}{arXiv})
}
}
\seealso{
\code{\link[LVGP]{LVGP_fit}} to see how a GP model can be fitted to a training dataset.\cr
\code{\link[LVGP]{LVGP_predict}} to use the fitted LVGP model for prediction.\cr
\code{\link[LVGP]{LVGP_plot}} to plot the features of the fitted model.
}
