% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_tau-utils.R, R/check_tau.R, R/complete_tau.R, R/get_initial_tau.R, R/normalize_by_tau.R, R/tau2theta.R, R/tau2type.R
\name{tau-utils}
\alias{check_tau}
\alias{complete_tau}
\alias{get_initial_tau}
\alias{normalize_by_tau}
\alias{tau-utils}
\alias{tau2theta}
\alias{tau2type}
\title{Utilities for transformation vector tau}
\usage{
check_tau(tau)

complete_tau(tau, type = tau2type(tau))

get_initial_tau(y, type = c("h", "hh", "s"), location.family = TRUE)

normalize_by_tau(data, tau, inverse = FALSE)

tau2theta(tau, beta)

tau2type(tau)
}
\arguments{
\item{tau}{named vector \eqn{\tau} which defines the variable transformation.
Must have at least \code{'mu_x'} and \code{'sigma_x'} element; see
\code{\link{complete_tau}} for details.}

\item{type}{type of Lambert W \eqn{\times} F distribution: skewed \code{"s"};
heavy-tail \code{"h"}; or skewed heavy-tail \code{"hh"}.}

\item{y}{a numeric vector of real values (the observed data).}

\item{location.family}{logical; if \code{FALSE} it sets \code{mu_x} to 0 and only estimates 
\code{sigma_x}; if \code{TRUE} (default), it estimates \code{mu_x} as well.}

\item{data}{numeric; a numeric object in R.  Usually this is either 
\code{y} or \code{x} (or \code{z} and \code{u} if \code{inverse = TRUE}.)}

\item{inverse}{logical; if \code{TRUE} it applies the inverse transformation
\eqn{data \cdot \sigma_x + \mu_x}}

\item{beta}{numeric vector (deprecated); parameter \eqn{\boldsymbol \beta} of
the input distribution.  See \code{\link{check_beta}} on how to specify
\code{beta} for each distribution.}
}
\value{
\code{check_tau} throws an error if \eqn{\tau} does not define a proper
    transformation.

\code{complete_tau} returns a named numeric vector.

\code{get_initial_tau} returns a named numeric vector.

\code{tau2theta} returns a list with entries \code{alpha}, \code{beta},
    \code{gamma}, and \code{delta}.

\code{tau2type} returns a string: either \code{"s"}, \code{"h"}, or
    \code{"hh"}.
}
\description{
All functions here are for the transformation parameter vector
    \eqn{\tau = (\mu_x, \sigma_x, \gamma, \delta, \alpha)}.

\code{check_tau} checks if \eqn{\tau} is correctly specified (correct names, non-negativity
constraints, etc.)

\code{complete_tau} completes missing values so users don't have to specify
    every element of \eqn{\tau} explicitly. \code{'mu_x'} and
    \code{'sigma_x'} must be specified, but \code{alpha = 1}, \code{gamma =
    0}, and \code{delta = 0} will be set automatically if missing.

\code{get_initial_tau} provides starting estimates for \eqn{\tau}.

\code{normalize_by_tau} shifts and scales data given the \code{tau} vector as
    \deqn{(data - \mu_x) / \sigma_x.}

Parameters \eqn{\mu_x} and \eqn{\sigma_x} are not necessarily mean and
    standard deviation in the \eqn{\tau} vector; that depends on the family
    type and \code{use.mean.variance} (for location families they usually are
    mean and standard deviation if \code{use.mean.variance = TRUE}; for scale
    and non-location non-scale families they are just location/scale
    parameters for the transformation).

\code{tau2theta} converts \eqn{\tau} to the parameter list \eqn{\theta} 
(inverse of \code{\link{theta2tau}}).

\code{tau2type} guesses the type (\code{'s'}, \code{'h'}, \code{'hh'}) from the names
of \code{tau} vector; thus make sure \code{tau} is named correctly.
}
\keyword{math}
\keyword{utilities}

