% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateArcAngles.R
\name{CreateArcAngles}
\alias{CreateArcAngles}
\title{Creates an arc of a circumference}
\usage{
CreateArcAngles(C, r, angle1, angle2, direction = "anticlock")
}
\arguments{
\item{C}{Vector containing the xy-coordinates of the center of the circumference}

\item{r}{Radius for the circumference (or arc)}

\item{angle1}{- Angle in degrees (0-360) at which the arc starts}

\item{angle2}{- Angle in degrees (0-360) at which the arc finishes}

\item{direction}{- String indicating the direction which is considered to create the arc, from the smaller to the higher angle. It has two possible values: "clock" (clockwise direction) and "anticlock" (anti-clockwise direction)}
}
\value{
Returns a vector which contains the center, radius, angles (0-360) and direction (1 - "clock", 2 - "anticlock") that define the created arc
}
\description{
\code{CreateArcAngles} creates an arc of a circumference
}
\examples{
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
C <- c(0,0)
r <- 3
angle1 <- 90
angle2 <- 180
direction <- "anticlock"
Arc1 <- CreateArcAngles(C, r, angle1, angle2, direction)
Draw(Arc1, "black")
direction <- "clock"
Arc2 <- CreateArcAngles(C, r, angle1, angle2, direction)
Draw(Arc2, "red")
}
