% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{crossAdducts}
\alias{crossAdducts}
\title{Cross different candidates tables to remove false positives.}
\usage{
crossAdducts(df1, df2, rttol, rawData, coelCutoff)
}
\arguments{
\item{df1}{data frame containing identification results using the main adduct}

\item{df2}{data frame containing identification results using a secondary
adduct}

\item{rttol}{retention time tolerance in seconds}

\item{rawData}{raw scans data. Output of \link{dataProcessing} function
(MS1$rawData).}

\item{coelCutoff}{coelution score threshold between parent and fragment ions.
Only applied if rawData info is supplied.}
}
\value{
Subset of the original data frame without adducts
}
\description{
This function crosses tables of precursor candidates identified using different
adducts.
}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
\keyword{internal}
