% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.fastq.R
\name{write.fastq}
\alias{write.fastq}
\title{Write FASTQ Files}
\usage{
write.fastq(names, sequences, quality_scores, file, comments)
}
\arguments{
\item{names}{A character vector of sequence names.}

\item{sequences}{A character vector of sequences.}

\item{quality_scores}{A character vector of quality scores.}

\item{file}{A string specifying the path to a FASTQ file to write.}

\item{comments}{An optional character vector of sequence comments.}
}
\value{
No return value. Writes a FASTQ file.
}
\description{
Writes FASTQ files.
}
\examples{
# Get path to example sequences CSV file.
path_to_CSV_file<-system.file("extdata",
                              "example_query_sequences.csv",
                              package="LocaTT",
                              mustWork=TRUE)

# Read the example sequences CSV file.
df<-read.csv(file=path_to_CSV_file,stringsAsFactors=FALSE)

# Create a temporary file path for the FASTQ file to write.
path_to_FASTQ_file<-tempfile(fileext=".fastq")

# Write the example sequences as a FASTQ file.
write.fastq(names=df$Name,
            sequences=df$Sequence,
            quality_scores=df$Quality_score,
            file=path_to_FASTQ_file,
            comments=df$Comment)
}
\seealso{
\code{\link[=read.fastq]{read.fastq}} for reading FASTQ files. \cr
\code{\link[=write.fasta]{write.fasta}} for writing FASTA files. \cr
\code{\link[=read.fasta]{read.fasta}} for reading FASTA files.
}
