% Generated by roxygen2 (4.0.1): do not edit by hand
\name{OR}
\alias{OR}
\alias{OR.default}
\alias{OR.glm}
\title{\bold{O}dds \bold{r}atio
for binary regression models fit with \code{glm}}
\usage{
OR(x, ...)

\method{OR}{default}(x, ...)

\method{OR}{glm}(x, ..., newdata = rep(1L, length(stats::coef(x))),
  ci = TRUE, alpha = 0.95, what = c("model", "all", "data"))
}
\arguments{
\item{x}{A numeric object
containing probabilities \eqn{P}.
\cr
I.e. the range of \eqn{P} must be \eqn{0} to \eqn{1}.
\cr
The odds ratio \eqn{OR} is given by:
\deqn{OR_i = \frac{P_i}{1-P_i} = \frac{\frac{P_1}{1-P_1}}{\frac{P_0}{1-P_0}} =
             \frac{\mathrm{odds_1}}{\mathrm{odds_0}}}{
      OR = P[i] / (1-P[i]) = odds[1] / odds[0]}

There is a method for regression models with \code{class(x)==glm} and
\code{x$family$family == "binomial"}.}

\item{...}{Not used.}

\item{newdata}{A \code{vector} of new variables to use.
\cr
There should be one value, in sequence, for each coefficient
in the model.
\cr
By default, values are calculated for a change in the value of the
coefficient for the predictor from \eqn{0} to \eqn{1}.
\cr
For continuous predictors changes of \eqn{> 1}
unit may have more practical significance.}

\item{ci}{If \code{ci=TRUE} (the default), include
a confidence interval for \eqn{P_i}{P[i]} and \eqn{OR_i}{OR[i]} in the returned values.}

\item{alpha}{Used to cacluate the confidence interval, which is:
 \deqn{\mathrm{CI} = x \pm Z_{1 - \alpha} \sigma}{
       CI = x +- Z[1-alpha].SD}
where the normal distribution \eqn{Z \sim N (0,1)}{Z = N(0,1)} and
\eqn{\sigma}{SD} is the standard deviation.}

\item{what}{See \bold{Value} below.}
}
\value{
A \code{data.table}.
Columns give the model, the value of the link function and
the associated probability \eqn{P_i}{P[i]} and odds ratio \eqn{OR_i}{OR[i]}.
\cr \cr
If \code{ci=TRUE}, will also give upper and lower bounds of the
confidence intervals for these values.
\cr \cr
Rows are determined by \code{what}:
\item{\code{what="model"}}{
 The value of the link function is given
 for the full model.
 \cr
 If an intercept term is included, the value if given
 with \emph{and} without the intercept.
}

\item{\code{what="all"}}{
 The value of the link function is given for each
 \emph{combination} of coefficients in the model.
}

\item{\code{what="data"}}{
 The value of the link function is given
 for each set of predictors in the data with which
 the model was fit.
 \cr
 This option will ignore the argument \code{newdata}.
}
}
\description{
\bold{O}dds \bold{r}atio
for binary regression models fit with \code{glm}


}
\note{
In the model formulas, the intercept term is specified as
\code{0} (absent) or \code{1} (present).
\cr
The variance of the values of the link function is:
\deqn{\sigma ^2 = \sum x_i^2 \sigma^2(\hat{\beta_i}) +
                  \sum 2x_ix_j cov(\hat{\beta_i}, \hat{\beta_j})}{
      Var = SUM(x[i]^2.var(B[i])) + SUM(2.x[i][x[j]].cov(B[i], B[j]))}
where \eqn{\sigma^2}{Var} is the variance and
\eqn{cov} is the covariance.
\cr \cr
}
\examples{
if(require("graphics")){
    plot(x <- seq(from=0.1, to=0.9, by=0.05), y=OR(x))}
## H&L 2nd ed. Table 1.3. Page 10.
data(ageChd)
summary(g1 <- glm(chd ~ age, data=ageChd, family=binomial))
OR(g1)
attributes(OR(g1))
## Table 1.4. Page 20.
stats::vcov(g1)
## Table 2.3. Page 38.
data(lbw)
summary(g1 <- glm(LOW ~ LWT + RACE, data=lbw, family=binomial))
## Table 2.4. Page 42.
vcov(g1)
ageChd$gr54 <- ageChd$age > 54
OR(glm(chd ~ gr54, data=ageChd, family=binomial))
}
\seealso{
?stats::predict.glm
}

