\name{plot_GrowthCurve}
\alias{plot_GrowthCurve}
\title{Fit and plot a growth curve for luminescence data (Lx/Tx against dose)}
\description{A dose response curve is produced for luminescence measurements using a 
regenerative protocol.}
\usage{plot_GrowthCurve(sample, na.exclude = TRUE, main = "Growth Curve", 
    mtext = "", fit.method = "EXP", fit.weights = TRUE, 
	 fit.includingRepeatedRegPoints = TRUE, 
    fit.NumberRegPoints, fit.NumberRegPointsReal, fit.bounds = TRUE, 
    NumberIterations.MC = 100, xlab = "s", output.plot = TRUE, 
    output.plotExtended = TRUE, cex.global = 1)}
\arguments{
  \item{sample}{\code{\link{data.frame}} (\bold{required}): data frame with three columns
for x=Dose,y=LxTx,z=LxTx.Error, y1=TnTx. The column for the test dose 
response is optional, but requires 'TnTx' as column name if used.}
  \item{na.exclude}{\code{\link{logical}} (with default): exclude NA values from the data 
set prior to any further operations.}
  \item{main}{\code{\link{character}} (with default): header of the plot.}
  \item{mtext}{\code{\link{character}} (optional): additional text on the right side 
of the plot.}
  \item{fit.method}{\code{\link{character}} (with default): functions used for fitting. 
Possible options are: \code{LIN}, \code{EXP}, \code{EXP OR LIN}, 
\code{EXP+LIN} or \code{EXP+EXP}. See details.}
  \item{fit.weights}{\code{\link{logical}} (with default): option whether the fitting is 
done with or without weights. See details.}
  \item{fit.includingRepeatedRegPoints}{\code{\link{logical}} (with default): includes repeated points for 
fitting (\code{TRUE}/\code{FALSE}).}
  \item{fit.NumberRegPoints}{\code{\link{integer}} (optional): set number of regeneration points 
manually. By default the number of all(!) regeneration points is 
grepped automatically.}
  \item{fit.NumberRegPointsReal}{\code{\link{integer}} (optional): if the number of regeneration points 
is provided manually the value of the real regenerations points = 
all points - repeated points - reg 0 has to be inserted.}
  \item{fit.bounds}{\code{\link{logical}} (with default): set lower fit bounds for fitting 
parameter to 0. Limited for the use with the fit methods \code{EXP}, 
\code{EXP+LIN} and \code{EXP OR LIN}. Argument to be inserted for 
experimental application only!}
  \item{NumberIterations.MC}{\code{\link{integer}} (with default): number of Monte Carlo simulations 
for the error estimation. See details.}
  \item{xlab}{\code{\link{character}} (with default): unit for x-axis labelling. 
Possible values are \code{"Gy"} and \code{"s"}.}
  \item{output.plot}{\code{\link{logical}} (with default): plot output (\code{TRUE/FALSE}).}
  \item{output.plotExtended}{\code{\link{logical}} (with default): If \code{TRUE} 3-plots on one plot 
area are provided: (1) growth curve, (2) histogram from error Monte 
Carlo simulation and (3) a test dose response plot. If \code{FALSE}, 
just the growth curve will be plotted. \bold{Requires:} 
\code{output.plot = TRUE}.}
  \item{cex.global}{\code{\link{numeric}} (with default): global scaling factor.}
}
\details{\bold{Fitting methods} \cr
For all options (except for the \code{LIN} and the \code{EXP OR LIN}), 
the \link{nls} function with the \code{port} algorithm is used. \cr
\code{LIN}: fit a linear function to the data using \link{lm}:
\deqn{y = m*x+n}
\code{EXP}: try to fit a function of the form 
\deqn{y = a*(1-exp(-(x+c)/b))}
Parameters b and c are approximated by a linear fit using \link{lm}.\cr
\code{EXP OR LIN}: works for some cases where an \code{EXP} fit failes. 
If the \code{EXP} fit failes, a \code{LIN} fit is done instead. \cr
\code{EXP+LIN}: try to fit an exponential plus linear function of the 
form: \deqn{y = a*(1-exp(-(x+c)/b)+(g*x))}
The De is calculated by iteration.\cr
\bold{Note:} In the context of luminescence dating, this function has 
no physical meaning. Therefore, no D0 value is returned.\cr
\code{EXP+EXP}: try to fit a double exponential function of the form
\deqn{y = (a1*(1-exp(-(x)/b1)))+(a2*(1-exp(-(x)/b2)))}
This fitting procedure is not robust against wrong start parameters 
and should be further improved.\cr\cr
\bold{Fit weighting} (suggested by Michael Dietze and Margret Fuchs)\cr
If the option \code{fit.weights = TRUE} is chosen weights are calculated 
using provided signal errors (Lx/Tx error):
\deqn{fit.weights = 1/error/(sum(1/error))}
\bold{Error estimation using Monte Carlo simulation}\cr
Error estimation is done using a Monte Carlo (MC) simulation approach. A 
set of values is constructed by randomly drawing curve data from a normal 
distribution. The normal distribution is defined by the input values 
(mean = value, sd = value.error). Then, a growth curve fit is attempted 
for each dataset which results in new distribution of values. The 
\link{sd} of this distribution is the error of the De. With increasing 
iterations, the error value is becoming more stable. \bold{Note:} It may 
take some calculation time with increasing MC runs, especially for the 
composed functions (\code{EXP+LIN} and \code{EXP+EXP}).\cr
Each error estimation is done with the function of the chosen fitting 
method. }
\value{an \code{RLum.Results} object containing the De (De, De Error, D01 value, D02 value and Fit 
type) and Fit object \link{nls} object for \code{EXP}, \code{EXP+LIN} 
and \code{EXP+EXP}. In case of a linear fit \code{EXP OR LIN}, a 
\link{lm} object is returned. A plot is also returned.}

\author{Sebastian Kreutzer, JLU Giessen (Germany), Michael Dietze, GFZ Potsdam (Germany)
R Luminescence Package Team}




\examples{
##(1) plot growth curve for a dummy data.set
data(ExampleData.LxTxData, envir = environment())
plot_GrowthCurve(LxTxData)


##(2) plot the growth curve only

##pdf(file = "~/Desktop/Growth_Curve_Dummy.pdf", paper = "special")
data(ExampleData.LxTxData, envir = environment())
plot_GrowthCurve(LxTxData)
##dev.off()                                   

##(3) plot growth curve with pdf output on desktop (path works for Mac)

##pdf(file = "~/Desktop/Growth_Curve_Dummy.pdf", paper = "special")
data(ExampleData.LxTxData, envir = environment())
plot_GrowthCurve(LxTxData)
##dev.off()  
}
