% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gSGC.R
\name{calc_gSGC}
\alias{calc_gSGC}
\title{Calculate De value based on the gSGC by Li et al., 2015}
\usage{
calc_gSGC(data, gSGC.type = "0-250", gSGC.parameters, n.MC = 100,
  verbose = TRUE, plot = TRUE, ...)
}
\arguments{
\item{data}{\code{\link{data.frame}} (\bold{required}): input data of providing the following
columns: 'LnTn', 'LnTn.error', Lr1Tr1', 'Lr1Tr1.error', 'Dr1'
Note: column names are not required. The function expect the input data in the given order}

\item{gSGC.type}{\code{\link{character}} (with default): define the function parameters that
should be used for the iteration procedure: Li et al., 2015 (Table 2)
presented function parameters for two dose ranges: \code{"0-450"} and \code{"0-250"}}

\item{gSGC.parameters}{\code{\link{list}} (optional): option to provide own function
parameters used for #' fitting as named list.
Nomenclature follows Li et al., 2015, i.e.
\code{list(A,A.error,D0,D0.error,c,c.error,Y0,Y0.error,range)}, range requires a vector for
the range the function is considered as valid, e.g. \code{range = c(0,250)}\cr
Using this option overwrites the default parameter list of the gSGC, meaning the argument
\code{gSGC.type} will be without effect}

\item{n.MC}{\code{\link{integer}} (with default): number of Monte Carlo simulation runs for
error estimation, s. details.}

\item{verbose}{\code{\link{logical}}: enable or disable terminal output}

\item{plot}{\code{\link{logical}}: enable or disable graphical feedback as plot}

\item{...}{parameters will be passed to the plot output}
}
\value{
Returns an S4 object of type \code{\linkS4class{RLum.Results}}.
Slot \code{data} contains a \code{\link{list}} with the following structure:\cr
$ De.value (data.frame) \cr
 .. $ De  \cr
 .. $ De.error \cr
 .. $ Eta \cr
$ De.MC (list) contains the matricies from the error estimation.\cr
$ uniroot (list) contains the uniroot outputs of the De estimations
$ call (call) the original function call
}
\description{
Function returns De value and De value error using the global standardised growth
curve (gSGC) assumption proposed by Li et al., 2015 for OSL dating of sedimentary quartz
}
\details{
The error of the De value is determined using a Monte Carlo simulation approach.
Solving of the equation is realised using \code{\link{uniroot}}.
Large values for \code{n.MC} will significantly increase the computation time.
}
\section{Function version}{
 0.1.0 (2015-12-05 15:52:49)
}
\examples{
results <- calc_gSGC(data = data.frame(
LnTn =  2.361, LnTn.error = 0.087,
Lr1Tr1 = 2.744, Lr1Tr1.error = 0.091,
Dr1 = 34.4))

get_RLum(results, data.object = "De")

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montagine (France)\cr
\cr R Luminescence Package Team}
\references{
Li, B., Roberts, R.G., Jacobs, Z., Li, S.-H., 2015. Potential of establishing
a 'global standardised growth curve' (gSGC) for optical dating of quartz from sediments.
Quaternary Geochronology 27, 94-104. doi:10.1016/j.quageo.2015.02.011
}
\seealso{
\code{\linkS4class{RLum.Results}}, \code{\link{get_RLum}}, \code{\link{uniroot}}
}
\keyword{datagen}

