% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_RLum.R
\name{structure_RLum}
\alias{structure_RLum}
\title{General structure function for RLum S4 class objects}
\usage{
structure_RLum(object, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum}} (\bold{required}): S4 object of
class \code{RLum}}

\item{\dots}{further arguments that one might want to pass to the specific
structure method}
}
\value{
Returns a \code{data.frame} with structure of the object.
}
\description{
Function calls object-specific get functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for specific
\code{\linkS4class{RLum}} objects.\cr Depending on the input object, the
corresponding structure function will be selected. Allowed arguments can be found
in the documentations of the corresponding \code{\linkS4class{RLum}} class.
}
\section{Function version}{
 0.2.0 (2016-05-02 09:36:06)
}

\examples{

##load example data
data(ExampleData.XSYG, envir = environment())

##show structure
structure_RLum(OSL.SARMeasurement$Sequence.Object)

}
\seealso{
\code{\linkS4class{RLum.Data.Curve}},
\code{\linkS4class{RLum.Data.Image}},
\code{\linkS4class{RLum.Data.Spectrum}},
\code{\linkS4class{RLum.Analysis}},
\code{\linkS4class{RLum.Results}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team} 

\section{How to cite}{
Kreutzer, S. (2017). structure_RLum(): General structure function for RLum S4 class objects. Function version 0.2.0. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.1. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
