% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names_RLum.R
\docType{methods}
\name{names_RLum}
\alias{names_RLum}
\alias{names_RLum,list-method}
\title{S4-names function for RLum S4 class objects}
\usage{
names_RLum(object)

\S4method{names_RLum}{list}(object)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}
}
\value{
Returns a \link{character}
}
\description{
Function calls object-specific names functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for specific
\linkS4class{RLum} objects.\cr
Depending on the input object, the corresponding 'names' function will be
selected. Allowed arguments can be found in the documentations of the
corresponding \linkS4class{RLum} class.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: Returns a list of \linkS4class{RLum} objects that had been passed to \link{names_RLum}
}}

\section{Function version}{
 0.1.0 (2018-01-30 16:35:49)
}

\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
\cr R Luminescence Package Team} 

\section{How to cite}{
Kreutzer, S. (2018). names_RLum(): S4-names function for RLum S4 class objects. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.2. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
