% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_Data.R
\name{import_Data}
\alias{import_Data}
\title{Import Luminescence Data into R}
\usage{
import_Data(file, ..., fastForward = TRUE, verbose = FALSE)
}
\arguments{
\item{file}{\link{character} (\strong{required}): file to be imported, can be a \link{list} or a \link{character} vector}

\item{...}{arguments to be further passed down to supported functions (please check the functions
to determine the correct arguments)}

\item{fastForward}{\link{logical} (\emph{with default}): option to create \linkS4class{RLum} objects
during import or a \link{list} of such objects}

\item{verbose}{\link{logical} (\emph{with default}): enable/disable output to the
terminal.}
}
\value{
Always returns a \link{list}; empty or filled with \linkS4class{RLum.Analysis} objects
}
\description{
Convenience wrapper function to provide a quicker and more standardised way of
reading data into R by looping through all in the package available data import
functions starting with \code{read_}. Import data types can be mixed.
}
\section{Function version}{
 0.1.5
}

\examples{

## import BINX/BIN
file <- system.file("extdata/BINfile_V8.binx", package = "Luminescence")
temp <- import_Data(file)

## RF data
file <- system.file("extdata", "RF_file.rf", package = "Luminescence")
temp <- import_Data(file)

}
\seealso{
\link{read_HeliosOSL2R}, \link{read_BIN2R}, \link{read_Daybreak2R}, \link{read_RF2R}, \link{read_SPE2R}, \link{read_PSL2R}, \link{read_XSYG2R}, \link{read_TIFF2R}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. import_Data(): Import Luminescence Data into R. Function version 0.1.5. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\keyword{datagen}
