/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import uk.ac.rhul.cs.graph.Edge;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.graph.GraphLayoutAlgorithm;
import uk.ac.rhul.cs.graph.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphRenderer
implements Callable<Icon> {
    GraphLayoutAlgorithm algorithm = null;
    HashMap<Integer, Color> colors = null;
    Layout layout = null;

    public GraphRenderer(Graph graph, GraphLayoutAlgorithm algorithm, HashMap<Integer, Color> colors) {
        this.algorithm = algorithm;
        this.algorithm.setGraph(graph);
        this.colors = colors;
    }

    public GraphRenderer(Graph graph, GraphLayoutAlgorithm algorithm) {
        this(graph, algorithm, new HashMap<Integer, Color>());
    }

    private void calculateLayout() {
        if (this.layout == null) {
            this.layout = this.algorithm.getResults();
        }
    }

    public void render(Graphics2D g, Rectangle2D rect) {
        this.calculateLayout();
        this.layout.fitToRectangle(rect);
        Graph graph = this.algorithm.getGraph();
        int n = this.layout.size();
        if (graph.getNodeCount() != n) {
            System.out.println("hmmm, wtf?");
            return;
        }
        g.setColor(Color.BLACK);
        for (Edge edge : graph) {
            Point2D from = this.layout.getCoordinates(edge.source);
            Point2D to = this.layout.getCoordinates(edge.target);
            g.drawLine((int)from.getX(), (int)from.getY(), (int)to.getX(), (int)to.getY());
        }
        for (int i = 0; i < n; ++i) {
            Point2D point = this.layout.getCoordinates(i);
            Color color = this.colors.get(i);
            if (color == null) {
                color = Color.RED;
            }
            g.setColor(color);
            g.fillOval((int)point.getX() - 2, (int)point.getY() - 2, 5, 5);
        }
    }

    public void render(BufferedImage image) {
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(new Color(0, 0, 0, 0));
        g2d.setComposite(AlphaComposite.Src);
        g2d.fill(new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight()));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D.Double rect = new Rectangle2D.Double(3.0, 3.0, image.getWidth() - 6, image.getHeight() - 6);
        this.render(g2d, rect);
    }

    @Override
    public Icon call() throws Exception {
        BufferedImage image = new BufferedImage(50, 50, 2);
        this.render(image);
        return new ImageIcon(image);
    }
}

