% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_model.R
\name{ensemble_model}
\alias{ensemble_model}
\title{Predict Interactions via Ensemble Learning Method}
\usage{
ensemble_model(
  features,
  gd,
  classifier = c("glm", "svmRadial", "ranger"),
  cv_fold = 2,
  verboseIter = TRUE,
  plots = FALSE,
  filename = file.path(tempdir(), "plots.pdf")
)
}
\arguments{
\item{features}{A data frame with protein-protein associations in the
first column, and features to be passed to the classifier in the remaining
columns.}

\item{gd}{A gold reference set including true associations with class
labels indicating if such PPIs are positive or negative.}

\item{classifier}{The type of classifier to use. See \code{caret}
for the available classifiers.}

\item{cv_fold}{Number of partitions for cross-validation; defaults to 5.}

\item{verboseIter}{Logical value, indicating whether to check the status
of training process;defaults to FALSE.}

\item{plots}{Logical value, indicating whether to plot the performance
of ensemble learning algorithm as compared to individual classifiers;
defaults to FALSE.If the argument set to TRUE, plots will be saved in
the current working directory.
These plots are :
\itemize{
\item{pr_plot} - Precision-recall plot of ensemble classifier vs
selected individual classifiers.
\item{roc_plot} - ROC plot of ensemble classifier vs selected individual
classifiers.
\item{points_plot} - Plot accuracy, F1-score ,positive predictive value
(PPV),sensitivity (SE), and Matthews correlation coefficient (MCC) of
ensemble classifier vs selected individual classifiers.
}.}

\item{filename}{character string, indicating the location and output
pdf filename for for performance plots. Defaults to tempdir().}
}
\value{
Ensemble_training_output
\itemize{
\item{prediction score} - Prediction scores for whole dataset from each
individual classifier.
\item{Best} - Selected hyper parameters.
\item{Parameter range} - Tested hyper parameters.
\item{prediction_score_test} - Scores probabilities for test data from
each individual classifier.
\item{class_label} -  Class probabilities for test data from each
individual classifier.
}
classifier_performance
\itemize{
\item{cm} - A confusion matrix.
\item{ACC} - Accuracy.
\item{SE} - Sensitivity.
\item{SP} - Specificity.
\item{PPV} - Positive Predictive Value.
\item{F1} - F1-score.
\item{MCC} - Matthews correlation coefficient.
\item{Roc_Object} - A list of elements.
See \code{\link[pROC]{roc}} for more details.
\item{PR_Object} - A list of elements.
See \code{\link[PRROC]{pr.curve}} for more details.
}
predicted_interactions - The input data frame of pairwise interactions,
including classifier scores averaged across all models.
}
\description{
This function uses individual or an ensemble of classifiers to
predict interactions from CF-MS data. This ensemble
algorithm combines different results generated from individual
classifiers within the ensemble via average to enhance prediction.
}
\details{
ensemble_model
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
