% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_07_PREDICT_NMD_6_PropPTC.R
\name{PropPTC}
\alias{PropPTC}
\title{Proportion of Transcripts with PTC}
\usage{
PropPTC(MarvelObject, xlabels.size = 8, show.NovelSJ.NoCDS = TRUE, prop.test)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{FindPTC} function.}

\item{xlabels.size}{Numeric value. Size of the x-axis tick labels. Default is 8.}

\item{show.NovelSJ.NoCDS}{Logical value. If set to \code{TRUE} transcripts not analysed for premature terminal codon (PTC), e.g. non-protein-coding transcripts are tabulated and plotted.}

\item{prop.test}{Character string. \code{chisq} Chi-squared test used to compare the proportion of transcripts with PTC across the different event splicing type. \code{fisher} Fisher test used to compare the proportion of transcripts with PTC across the different splicing event type.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$NMD$PTC.Prop}.
}
\description{
\code{PlotValues.Exp} Tabulates and plots the proportion of transcripts with PTC for each splicing event type.
}
\details{
This function tabulates and plots the proportion of transcripts with PTC for each splicing event type. Useful for checking for any enrichment of PTCs in certain splicing event type(s).
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- PropPTC(MarvelObject=marvel,
                  xlabels.size=8,
                 show.NovelSJ.NoCDS=FALSE,
                 prop.test="fisher"
                 )

# Check output
marvel$NMD$PTC.Prop$Table[1:5, ]
marvel$NMD$PTC.Prop$Plot
marvel$NMD$PTC.Prop$Plot.Stats
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
