% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_02_PREPROCESS_2_AnnotateSJ.R
\name{AnnotateSJ.10x}
\alias{AnnotateSJ.10x}
\title{Annotate splice junctions}
\usage{
AnnotateSJ.10x(MarvelObject)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{AnnotateGenes.10x} function.}
}
\value{
An object of class S3 containing the updated slot \code{MarvelObject$sj.metadata}.
}
\description{
Annotates the splice junctions by assigning the gene name to the start and end of the splice junction. Annotations are retrieved from GTF.
}
\examples{

# Load un-processed MARVEL object
marvel.demo.10x.raw <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.raw.rds",
                               package="MARVEL")
                               )

# Annotate gene metadata
marvel.demo.10x <- AnnotateGenes.10x(MarvelObject=marvel.demo.10x.raw)

# Annotate junction metadata
marvel.demo.10x <- AnnotateSJ.10x(MarvelObject=marvel.demo.10x)
}
