% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_08_DE_6_2_GO_Plot.R
\name{BioPathways.Plot}
\alias{BioPathways.Plot}
\title{Plot pathway enrichment analysis results}
\usage{
BioPathways.Plot(
  MarvelObject,
  go.terms,
  y.label.size = 10,
  offset = 0.5,
  x.axis = "enrichment"
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{BioPathways} function.}

\item{go.terms}{Vector of character strings. Names of pathways to plot. Should match pathway names in column \code{Description} of \code{MarvelObject$DE$BioPathways$Table}.}

\item{y.label.size}{Numeric value. Size of y-axis tick labels, i.e. gene set names.}

\item{offset}{Numeric value. The -log10(p-value) on the x-axis to substract or add to increase the plot margins.}

\item{x.axis}{Character string. If set to \code{"enrichment"} (default) the pathway enrichment will be displayed on the x-axis while the color intensity of the data points will reflect the -log10(adjusted p-value). If set to \code{"pval"} the -log10(adjusted p-value) will be displayed on the x-axis while the color intensity of the data points will reflect the pathway enrichment.}
}
\value{
An object of class S3 with new slot \code{MarvelObject$DE$BioPathways$Plot}.
}
\description{
Plots user-specified enriched pathways.
}
\details{
This function plots selected gene sets returned from gene ontology analysis performed previously using \code{BioPathways}
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

# Define go terms to plot
df <- marvel.demo$DE$BioPathways$Table
go.terms <- df$Description[c(1:10)]

# Plot
marvel.demo <- BioPathways.Plot(MarvelObject=marvel.demo,
                                go.terms=go.terms,
                                offset=10
                                )

# Check output
marvel.demo$DE$BioPathways$Plot
}
