% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_01_CREATE_MARVEL_OBJECT.R
\name{CreateMarvelObject}
\alias{CreateMarvelObject}
\title{Create Marvel object for plate-based RNA-sequencing data}
\usage{
CreateMarvelObject(
  SplicePheno = NULL,
  SpliceJunction = NULL,
  IntronCounts = NULL,
  SpliceFeature = NULL,
  SpliceFeatureValidated = NULL,
  PSI = NULL,
  GeneFeature = NULL,
  Exp = NULL,
  GTF = NULL
)
}
\arguments{
\item{SplicePheno}{Data frame. Sample metadata.}

\item{SpliceJunction}{Data frame. Splice junction counts matrix.}

\item{IntronCounts}{Data frame. Intron coverage matrix.}

\item{SpliceFeature}{List of data frames. Each data frame is the exon-level alternative splicing event metadata.}

\item{SpliceFeatureValidated}{List of data frames. Each data frame is the validated (high-quality) exon-level alternative splicing event metadata.}

\item{PSI}{Data frame. PSI matrix.}

\item{GeneFeature}{Data frame. Gene metadata.}

\item{Exp}{Data frame. Normalised, non-log2-transformed gene expression matrix.}

\item{GTF}{Data frame. GTF used for generating the exon-level alternative splicing event metadata.}
}
\value{
An object of class S3.
}
\description{
Creates an S3 object named \code{Marvel} for downstream analysis, specifically for plate-based RNA-sequencing data.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

SpliceJunction <- marvel.demo$SpliceJunction
SpliceJunction[1:5,1:5]

SplicePheno <- marvel.demo$SplicePheno
SplicePheno[1:5,]

SpliceFeature <- marvel.demo$SpliceFeature
SpliceFeature[["SE"]][1:5, ]

IntronCounts <- marvel.demo$IntronCounts
IntronCounts[1:5,1:5]

GeneFeature <- marvel.demo$GeneFeature
GeneFeature[1:5, ]

Exp <- marvel.demo$Exp
Exp[1:5,1:5]

marvel <- CreateMarvelObject(SpliceJunction=SpliceJunction,
                             SplicePheno=SplicePheno,
                             SpliceFeature=SpliceFeature,
                             IntronCounts=IntronCounts,
                             GeneFeature=GeneFeature,
                             Exp=Exp
                             )
class(marvel)
}
