% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_04_DE_4_VolcanoPlot_Gene.R
\name{PlotDEValues.Genes.10x}
\alias{PlotDEValues.Genes.10x}
\title{Plot differential gene analysis results}
\usage{
PlotDEValues.Genes.10x(
  MarvelObject,
  pval.sj = 0.05,
  log2fc.sj = NULL,
  delta.sj = 5,
  min.gene.norm = 0,
  pval.adj.gene = 0.05,
  log2fc.gene = 0.5,
  anno = FALSE,
  anno.gene_short_name = NULL,
  label.size = 2
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareValues.Genes.10x} function.}

\item{pval.sj}{Numeric value. p-value from differential splicing analysis, below which, the splice junction is considered differentially spliced. Default is \code{0.05}.}

\item{log2fc.sj}{Numeric value. Absolute log2 fold change from differential splicing analysis, above which, the splice junction is considered differentially spliced. This option should be \code{NULL} if \code{delta.sj} has been specified.}

\item{delta.sj}{Numeric value. Absolute difference in average PSI values between the two cell groups, above which, the splice junction is considered differentially spliced. This option should be \code{NULL} if \code{log2fc.sj} has been specified.}

\item{min.gene.norm}{Numeric value. The average normalised gene expression across the two cell groups above which the splice junction is considered differentially spliced. Default is \code{0}.}

\item{pval.adj.gene}{Numeric value. Adjusted p-value from differential gene expression analysis, below which, the gene is considered differentially expressed. Default is \code{0.05}.}

\item{log2fc.gene}{Numeric value. Absolute log2 fold change from differential gene expression analysis, above which, the gene is considered differentially expressed. This option should be \code{NULL} if \code{delta.sj} has been specified.}

\item{anno}{Logical value. If set to \code{TRUE}, user-specific genes in \code{anno.gene_short_name} will be annotated on the plot. Default is \code{FALSE}.}

\item{anno.gene_short_name}{Vector of character strings. If \code{anno} set to \code{TRUE}, genes specified here will be annotated on the plot.}

\item{label.size}{Numeric value. If \code{anno} set to \code{TRUE}, the font size of the annotations on the plot will be adjusted to the size specified here. Default is \code{2}.}
}
\value{
An object of class S3 with a new slots \code{MarvelObject$DE$SJ$VolcanoPlot$Gene$Plot} and \code{MarvelObject$DE$SJ$VolcanoPlot$Gene$Data}.
}
\description{
Volcano plot of results from differential gene expression analysis. x-axis represents the log2 fold change between two cell groups. y-axis represents -log10(adjusted p-value). Only genes whose splice junctions were considered to be differentially spliced are included for plotting.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

marvel.demo.10x <- PlotDEValues.Genes.10x(
                        MarvelObject=marvel.demo.10x,
                        pval.sj=0.05,
                        delta.sj=5,
                        min.gene.norm=1.0,
                        pval.adj.gene=0.05,
                        log2fc.gene=0.5
                        )

# Check outputs
marvel.demo.10x$DE$SJ$VolcanoPlot$Gene$Plot
head(marvel.demo.10x$DE$SJ$VolcanoPlot$Gene$Data)
}
