% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARX_functions.R
\name{marx}
\alias{marx}
\title{The MARX function}
\usage{
marx(y, x, p_max, sig_level, p_C, p_NC)
}
\arguments{
\item{y}{Data vector of time series observations.}

\item{x}{Matrix of data (every column represents one time series). Specify NULL or "not" if not wanted.}

\item{p_max}{Maximum number of autoregressive parameters (leads + lags) to be included.}

\item{sig_level}{Significance level for the construction of inference.}

\item{p_C}{Number of lags (if not specified by the user a model selection procedure is used to determine the number of lags).}

\item{p_NC}{Number of leads (if not specified by the user a model selection procedure is used to determine the number of leads).}
}
\value{
The function returns the values of the information criteria for the pseudo-causal models. The user is asked to choose a value for "p". Extensive output for the MARX(r,s,q) model (with p = r + s) which maximizes the log-likelihood is reported.
}
\description{
This interface-based function allows you to perform model selection for MARX models based on information criteria.
}
\details{
Mixed causal-noncausal autoregressions with exogenous regressors.
}
\examples{
data <- sim.marx(c('t',1,1), c('t',1,1),100,0.5,0.4,0.3)
p_max <- 8
sig_level <- 0.05
marx(data$y, data$x, p_max, sig_level,1,1) ## p_C and p_NC chosen to be 1: MARX(1,1,1) output.
marx(data$y, NULL, p_max,sig_level,1,1) ## MAR(1,1), no exogenous variable specified.
}
\author{
Sean Telg
}
\keyword{estimation}
\keyword{selection}
