% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_mave.R
\name{predict.mave}
\alias{predict.mave}
\title{Make predictions based on a 'mave' object}
\usage{
\method{predict}{mave}(object, newx, dim, ...)
}
\arguments{
\item{object}{the object of class 'mave'}

\item{newx}{Matrix of the new data to be predicted}

\item{dim}{the dimension of central space or central mean space. The matrix of the original data will be
multiplied by the matrix of dimension reduction directions of given dimension. Then the prediction will be
made based on the data of given dimensions.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
the prediced response of the new data
}
\description{
This method make predictions based the reduced dimension of data using nadaraya-watson method.
}
\examples{

X = matrix(rnorm(10000),1000,10)
beta1 = as.matrix(c(1,1,1,1,0,0,0,0,0,0))
beta2 = as.matrix(c(0,0,0,1,1,1,1,1,0,0))
err = as.matrix(rnorm(1000))
Y = X\%*\%beta1+X\%*\%beta2+err

train = sample(1:1000)[1:500]
x.train = X[train,]
y.train = as.matrix(Y[train])
x.test = X[-train,]
y.test = as.matrix(Y[-train])

dr = mave(y.train~x.train, method = 'meanopg')

yp = predict(dr,x.test,3)
#mean error
mean(abs(yp-y.test)/y.test)

}

