% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBPLS.R
\name{MBPLS}
\alias{MBPLS}
\title{Multiblock Partial Least Squares (MB-PLS) regression}
\usage{
MBPLS(
  X,
  Y,
  group,
  algo = "eigen",
  ncompprint = NULL,
  scale = "none",
  scaleY = "none",
  option = "uniform",
  optionY = "uniform",
  nstart = 10,
  threshold = 1e-08,
  plotgraph = TRUE,
  axes = c(1, 2)
)
}
\arguments{
\item{X}{Block obtained by horizontally merging all the explanatory blocks of variables.}

\item{Y}{Response block of variables.}

\item{group}{Vector indicating the number of variables in each explanatory block.}

\item{algo}{Type of algorithm to use. Either "eigen" (default) or "nipals".}

\item{ncompprint}{Number of global components to print.
By default (NULL), all the global components of the analysis are printed.}

\item{scale}{Type of standardization applied to the variables in the explanatory blocks. Either "none" (default) or "sd".
If scale="sd", each variable in the explanatory blocks is divided by its standard deviation.}

\item{scaleY}{Type of standardization applied to the variables in the response block. Either "none" (default) or "sd".
If scaleY="sd", each variable in the response block is divided by its standard deviation.}

\item{option}{Type of normalization applied to each explanatory block of variables (either "none" or "uniform").
If option="uniform" (default), each explanatory block of variables is divided by its Frobenius norm.}

\item{optionY}{Type of normalization applied to the response block of variables (either "none" or "uniform").
If optionY="uniform" (default), the response block of variables is divided by its Frobenius norm.}

\item{nstart}{Number of random initializations of the vector of Y loadings in case of nipals algorithm (by default 10).}

\item{threshold}{Value used to break the iterative loop (by default 1e-8).}

\item{plotgraph}{Boolean (TRUE/FALSE). If TRUE (default), graphs depicting scores of individuals, correlations of variables with the global components and contributions of blocks of variables to the determination of global components are displayed.}

\item{axes}{Vector that indicates the plane in which graphs should be depicted (by default the plane formed by the first two global components).}
}
\value{
Returns a list of the following elements:\cr

components  :  Numeric vector of length two that gives the number of global components of the analysis and the number of global components to print.

optimalcrit  :  Numeric vector that gives the optimal value of the criterion to be maximized for each dimension.

cumexplained   :  Four columns matrix of percentages of total inertia of the explanatory blocks, percentages of inertia of the response block
explained by the successive global components and their cumulative values.

explained.X  :  Matrix of percentages of inertia explained for each Xb block.

explained.Y  :  Matrix of percentages of inertia explained for each Y variable.

contrib  :  Matrix of contribution of each Xb block to the determination of global components.

T  :  Matrix of global components (scores of individuals).

C  :  Compromise matrix (unnormed global components).

U :  Matrix of components associated with the response block of variables.

globalcor  :  Matrix of correlation coefficients between the original variables and the global components.

cor.g.b  :  Array that gives the correlation of the global components with their respective block components.

betaY  :  Array of regression coefficients.

\item{Block}{ : Results associated with each block of variables.
         \itemize{
               \item {T.b}{ : Array that contains the matrices of block components.}
               \item {blockcor}{ : List of matrices of correlation coefficients between the original variables of each block of variables and the block components.}
       }}
}
\description{
MB-PLS regression applied to a set of quantitative blocks of variables.
}
\examples{
data(ham)
X=ham$X
group=ham$group
Y=ham$Y
res.mbpls <- MBPLS(X, Y, group)
res.mbpls

}
\references{
S. Wold (1984). Three PLS algorithms according to SW. In: Symposium MULDAST (Multivariate Analysis in
Science and Technology), Umea University, Sweden. pp. 26–30.\cr

E. Tchandao Mangamana, R. Glèlè Kakaï, E.M. Qannari (2021). A general strategy for setting up supervised methods of multiblock data analysis.
Chemometrics and Intelligent Laboratory Systems, 217, 104388.
}
\seealso{
\code{\link{print.MBPLS}}    \code{\link{plot.MBPLS}}    \code{\link{summary.MBPLS}}
}
\author{
Essomanda TCHANDAO MANGAMANA \email{tchanesso@yahoo.fr}, Véronique CARIOU, Evelyne VIGNEAU.
}
