% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ComDim.R
\name{summary.ComDim}
\alias{summary.ComDim}
\title{Summary Results for Common Dimensions analysis (ComDim)}
\usage{
\method{summary}{ComDim}(object, nvar = NULL, ncompprint = NULL, digits = 2, ...)
}
\arguments{
\item{object}{An object of class \code{ComDim}.}

\item{nvar}{Number of variables to print. By default (NULL), all the variables are printed.}

\item{ncompprint}{Number of global components to print. By default (NULL), the number of global components printed for the main function ComDim.}

\item{digits}{Number of decimal points (by default 2).}

\item{...}{Further arguments.}
}
\value{
Returns the percentages of inertia explained by successive global components, their cumulative values, the saliences and the correlations of the original variables with the global components.
}
\description{
Gives key results for ComDim.
}
\examples{
data(ham)
X=ham$X
group=ham$group
res.comdim <- ComDim(X, group, plotgraph=FALSE)
summary(res.comdim)
}
\seealso{
\code{\link{ComDim}}
}
\author{
Essomanda TCHANDAO MANGAMANA \email{tchanesso@yahoo.fr}, Véronique CARIOU, Evelyne VIGNEAU.
}
