% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.functions.R
\name{temax}
\alias{temax}
\title{Emax time-course function}
\usage{
temax(
  pool.emax = "rel",
  method.emax = "common",
  pool.et50 = "rel",
  method.et50 = "common",
  pool.hill = NULL,
  method.hill = NULL
)
}
\arguments{
\item{pool.emax}{Pooling for Emax parameter. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.emax}{Method for synthesis of Emax parameter. Can take \verb{"common} or \code{"random"} (see details).}

\item{pool.et50}{Pooling for ET50 parameter. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.et50}{Method for synthesis of ET50 parameter. Can take \verb{"common} or \code{"random"} (see details).}

\item{pool.hill}{Pooling for Hill parameter. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.hill}{Method for synthesis of Hill parameter. Can take \verb{"common} or \code{"random"} (see details).}
}
\value{
An object of \code{class("timefun")}
}
\description{
Emax time-course function
}
\details{
Emax represents the maximum response.
exp(ET50) represents the time at which 50\% of the maximum response is achieved.
exp(Hill) is the Hill parameter, which allows for a sigmoidal function.

Without Hill parameter:
\deqn{\frac{E_{max}\times{x}}{e^{ET_{50}}+x}}

With Hill parameter:
\deqn{\frac{E_{max}\times{x^{e^{hill}}}}{e^{ET_{50}\times{e^{hill}}}+x^{e^{hill}}}}
}
\section{Time-course parameters}{

Time-course parameters in the model must be specified using a \code{pool} and a \code{method} prefix.

\code{pool} is used to define the approach used for pooling of a given time-course parameter and
can take any of:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Indicates that \emph{relative} effects should be pooled for this time-course parameter. Relative effects preserve randomisation within included studies, are likely to vary less between studies (only due to effect modification), and allow for testing of consistency between direct and indirect evidence. Pooling follows the general approach for Network Meta-Analysis proposed by \insertCite{lu2004;textual}{MBNMAtime}. \cr
   \code{"abs"} \tab Indicates that study arms should be pooled across the whole network for this time-course parameter  \emph{independently of assigned treatment} to estimate an \emph{absolute} effect. This implies estimating a single value across the network for this time-course parameter, and may therefore be making strong assumptions of similarity. \cr
}


\code{method} is used to define the model used for meta-analysis for a given time-course parameter
and can take any of the following values:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"common"} \tab Implies that all studies estimate the same true effect (often called a "fixed effect" meta-analysis) \cr
   \code{"random"} \tab Implies that all studies estimate a separate true effect, but that each of these true effects vary randomly around a true mean effect. This approach allows for modelling of between-study heterogeneity. \cr
}


When relative effects are modelled on more than one time-course parameter,
correlation between them is automatically estimated using a vague inverse-Wishart prior.
This prior can be made slightly more informative by specifying the scale matrix \code{omega}
and by changing the degrees of freedom of the inverse-Wishart prior
using the \code{priors} argument in \code{mb.run()}.
}

\examples{
# Model without a Hill parameter
temax(pool.emax="rel", method.emax="random", pool.et50="abs", method.et50="common")

# Model including a Hill parameter and defaults for Emax and ET50 parameters
temax(pool.hill="abs", method.hill="common")

}
\references{
\insertAllCited
}
