% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.functions.R
\name{texp}
\alias{texp}
\title{Exponential time-course function}
\usage{
texp(
  pool.emax = "rel",
  method.emax = "common",
  pool.onset = NULL,
  method.onset = NULL
)
}
\arguments{
\item{pool.emax}{Pooling for exponential Emax parameter. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.emax}{Method for synthesis of exponential Emax parameter. Can take \verb{"common} or \code{"random"} (see Time-course parameters section).}

\item{pool.onset}{Pooling for parameter controlling speed of onset. Default is \code{NULL} which avoids including
this parameter (i.e. fixes it to 1 for all treatments). Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.onset}{Method for synthesis of parameter controlling speed of onset. Can take \verb{"common} or \code{"random"} (see Time-course parameters section).}
}
\value{
An object of \code{class("timefun")}
}
\description{
Similar parameterisation to the Emax model but with non-asymptotic maximal effect (Emax). Can fit
a 1-parameter (Emax only) or 2-parameter (includes onset parameter) model
}
\details{
1-parameter model:
\eqn{emax\times{(1-exp(-x))}}

2-parameter model:
\eqn{emax\times{(1-exp(exp(onset)*-x))}}
}
\section{Time-course parameters}{

Time-course parameters in the model must be specified using a \code{pool} and a \code{method} prefix.

\code{pool} is used to define the approach used for pooling of a given time-course parameter and
can take any of:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Indicates that \emph{relative} effects should be pooled for this time-course parameter. Relative effects preserve randomisation within included studies, are likely to vary less between studies (only due to effect modification), and allow for testing of consistency between direct and indirect evidence. Pooling follows the general approach for Network Meta-Analysis proposed by \insertCite{lu2004;textual}{MBNMAtime}. \cr
   \code{"abs"} \tab Indicates that study arms should be pooled across the whole network for this time-course parameter  \emph{independently of assigned treatment} to estimate an \emph{absolute} effect. This implies estimating a single value across the network for this time-course parameter, and may therefore be making strong assumptions of similarity. \cr
}


\code{method} is used to define the model used for meta-analysis for a given time-course parameter
and can take any of the following values:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"common"} \tab Implies that all studies estimate the same true effect (often called a "fixed effect" meta-analysis) \cr
   \code{"random"} \tab Implies that all studies estimate a separate true effect, but that each of these true effects vary randomly around a true mean effect. This approach allows for modelling of between-study heterogeneity. \cr
}
}

\examples{
texp(pool.emax="rel", method.emax="random")
texp(pool.emax="abs")

}
\references{
\insertAllCited
}
