% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{diabetes}
\alias{diabetes}
\title{Studies comparing treatments for type 2 diabetes}
\format{
A data frame in long format (one row per arm and study), with 28 rows and 7 variables:
\itemize{
\item \code{studyID} Study identifiers
\item \code{treatment} Numeric data indicating the treatment to which participants were randomised
\item \code{time} Numeric data indicating the time at which the observation was measured (given in weeks)
\item \code{y} Numeric data indicating the mean change from baseline in HbA1c in a study arm
\item \code{se} Numeric data indicating the standard error for the mean change from baseline in HbA1c in a study arm
\item \code{sd} Numeric data indicating the standard deviation for the mean change from baseline in HbA1c in a study arm
\item \code{n} Numeric data indicating the number of participants in each arm at each time-point
}
}
\usage{
diabetes
}
\description{
A dataset from of trials for reduction of haemoglobin A1c (HbA1c) in patients
with type 2 diabetes\insertCite{dingfu2013}{MBNMAtime}.
Data are reported in each study arm as mean change from baseline to follow-up.
The dataset includes 4 Randomised-Controlled Trials (RCTs), comparing 4 treatments.
}
\details{
\code{diabetes} is a data frame in long format (one row per observation, arm and study),
with the variables \code{studyID}, \code{treatment}, \code{time}, \code{y}, \code{se}, \code{sd}, and \code{n}.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
