% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateGamma.R
\name{estimateGamma}
\alias{estimateGamma}
\title{Estimate Gamma Distribution for MCMCtree analysis}
\usage{
estimateGamma(minAge, maxAge, phy, monoGroups, alpha = 188,
  beta = 2690, offset = 0.1, estimateAlpha = TRUE,
  estimateBeta = FALSE, plot = FALSE, pdfOutput = "gammaPlot.pdf",
  writeMCMCtree = FALSE, MCMCtreeName = "gammaInput.tre")
}
\arguments{
\item{minAge}{vector of minimum age bounds for nodes matching order in monoGroups}

\item{maxAge}{vector of maximum age bounds for nodes matching order in monoGroups}

\item{phy}{fully resolved phylogeny in ape format}

\item{monoGroups}{list  with each element containing species that define a node of interest}

\item{alpha}{alpha value for gamma distribution (default = 188)}

\item{beta}{beta value for gamma distribution (default = 2690)}

\item{offset}{distance of mean value from minimum bound}

\item{estimateAlpha}{logical specifying whether to estimate alpha with a given beta value (default = TRUE)}

\item{estimateBeta}{logical specifying whether to estimate beta with a given alpha value (default = FALSE)}

\item{plot}{logical specifying whether to plot to PDF}

\item{pdfOutput}{pdf output file name}

\item{writeMCMCtree}{logical whether to write tree in format that is compatible with MCMCTree to file}

\item{MCMCtreeName}{MCMCtree.output file name}
}
\value{
list containing node estimates for each distribution
\itemize{
 \item{"parameters"}{ estimated parameters for each node}
 \item{"apePhy"}{ phylogeny in \pkg{APE} format with node labels showing node distributions}
 \item{"MCMCtree"}{ phylogeny in MCMCtreeR format}
 \item{"nodeLabels"}{ node labels in MCMCtreeR format}
}

If plot=TRUE plot of distributions in file 'pdfOutput' written to current working directory

If writeMCMCtree=TRUE tree in MCMCtree format in file "MCMCtreeName" written to current working directory
}
\description{
Estimate the shape and rate paramaters of Gamma distribution and output trees for MCMCtree input
}
\examples{
data(apeData)
attach(apeData)
## extract taxon descending from calibrated nodes 8, 10, 11, 13
## these nodes can be visualised using plot.phylo
## and nodelabels from ape
monophyleticGroups <- tipDes(apeData$apeTree, c(8,10,11,13))
minimumTimes <- c("8"=15, "10"=6,
"11"=8, "13"=13) / 10
maximumTimes <- c("8" = 30, "10" = 12,
"11"=12, "13" = 20) / 10
gamma.nodes <- estimateGamma(minAge=minimumTimes, maxAge=maximumTimes, 
monoGroups=monophyleticGroups, alpha=188, beta=2690, 
offset=0.1, phy=apeTree, plot=FALSE)
gamma.nodes
}
\author{
Mark Puttick
}
