% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{repmat}
\alias{repmat}
\title{Fast replication of a matrix}
\usage{
repmat(x, nrow = 1L, ncol = 1L)
}
\arguments{
\item{x}{A matrix with dimensions r*c.}

\item{nrow}{An integer giving the number of times the matrix is replicated row-wise}

\item{ncol}{An integer giving the number of times the matrix is replicated column-wise}
}
\value{
A matrix with dimensions (r*nrow) x (c*ncol)
}
\description{
Fast generation of a matrix by replicating a matrix row- and column-wise in a block-like fashion
}
\examples{

m <- matrix(1:6, ncol=3)
repmat(m, 2)     # Stack two copies of m on top of each other
repmat(m, 2, 3)  # Replicate m with two copies on top and three copies side-by-side 

}
\author{
Claus Ekstrom <claus@rprimer.dk>
}
