% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{age}
\alias{age}
\title{Compute the age of a person from two dates.}
\usage{
age(from, to)
}
\arguments{
\item{from}{a vector of dates (birth dates)}

\item{to}{a vector of current dates}
}
\value{
A vector of ages (in years)
}
\description{
Compute the age in years of an individual based on the birth date and another date
}
\details{
For linear interpolation the auc function computes the area under the curve
using the composite trapezoid rule.  For area under a spline interpolation,
auc uses the splinefun function in combination with the integrate to
calculate a numerical integral. The auc function can handle unsorted time
values, missing observations, ties for the time values, and integrating over
part of the area or even outside the area.
}
\examples{

born <- c("1971-08-18", "2000-02-28", "2001-12-20")
check <- c("2016-08-28")
age(born, check)

}
\seealso{
\code{\link{as.POSIXlt}}
}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\keyword{datagen}
