% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mainfun.R
\name{MF1_single}
\alias{MF1_single}
\title{multifunctionality measures for a single ecosystem}
\usage{
MF1_single(func_data, species_data = NULL, weight = 1, q = c(0, 1, 2))
}
\arguments{
\item{func_data}{ecosystem function data should be input as a data.frame (ecosystems by functions). All function values must be normalized between 0 and 1.\cr
The row names of \code{func_data} should be set the same as the names of plotID specified in \code{species_data} if \code{species_data} is not \code{NULL}.}

\item{species_data}{species abundance data should be input as a data.frame and must include three columns: "plotID", "species" and "abundance" (or any proxy such as basal area). Default is \code{NULL}.}

\item{weight}{a constant number (if all weights are equal) or a numerical vector specifying weights for ecosystem functions.
In the latter case, the length of \code{weight} must be equal to the number of functions.
Default is \code{weight = 1}, which means equal weight and weight = 1 for all ecosystem functions.}

\item{q}{a numerical vector specifying the multifunctionality and diversity orders. Default is q = 0, 1 and 2.}
}
\value{
a data.frame with columns "plotID", "Type" (corr_uncorrected or corr_corrected), "Order.q" and "qMF" (multifunctionality of order q).
When \code{species_data} is not \code{NULL}, the data.frame will include an additional column "Species.diversity" in the last column.
}
\description{
\code{MF1_single} computes multifunctionality measures of orders q = 0, 1 and 2 for given function weights in a single ecosystem separately for two cases
(i) correlations between functions are not corrected for, and (ii) correlations between functions are corrected for. Species diversity of orders q = 0, 1, and 2 will also
be computed if species abundance data are provided.
}
\examples{

library(dplyr)

\donttest{
### Use data from the entire set of 209 plots in six countries

data("forest_function_data_normalized")
data("forest_biodiversity_data")
MF1_single(func_data = forest_function_data_normalized[,6:31], weight = 1,
           species_data = forest_biodiversity_data)
}

### Use partial data to quickly obtain output 
### (Take the first 18 plots in Germany and the last 18 plots in Italy)

data("forest_function_data_raw")
data("forest_biodiversity_data")
GER_ITA_forest_function_raw <- filter(forest_function_data_raw, 
                                      country=="GER"|country=="ITA")[c(1:18,57:74),]
GER_ITA_forest_function_normalized <- function_normalization(data = GER_ITA_forest_function_raw,
                                                             fun_cols = 6:31, 
                                                             negative = c("soil_cn_ff_10","wue"),
                                                             by_group = "country")
GER_ITA_forest_biodiversity <- forest_biodiversity_data[c(49:82,181:229),]
MF1_single(func_data = GER_ITA_forest_function_normalized[,6:31], weight = 1,
           species_data = GER_ITA_forest_biodiversity)

}
