% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_forward_selection.R
\name{MFKnockoffs.stat.forward_selection}
\alias{MFKnockoffs.stat.forward_selection}
\title{Forward selection statistics for MFKnockoffs}
\usage{
MFKnockoffs.stat.forward_selection(X, X_k, y, omp = FALSE)
}
\arguments{
\item{X}{original design matrix (size n-by-p)}

\item{X_k}{knockoff matrix (size n-by-p)}

\item{y}{response vector (length n). It should be numeric}

\item{omp}{whether to use orthogonal matching pursuit. Default is FALSE}
}
\value{
A vector of statistics \eqn{W} (length p)
}
\description{
Computes the statistic
  \deqn{W_j = \max(Z_j, Z_{j+p}) \cdot \mathrm{sgn}(Z_j - Z_{j+p}),}
where \eqn{Z_1,\dots,Z_{2p}} give the reverse order in which the 2p
variables (the originals and the knockoffs) enter the forward selection 
model.
See the Details for information about forward selection.
}
\details{
In \emph{forward selection}, the variables are chosen iteratively to maximize
the inner product with the residual from the previous step. The initial
residual is always \code{y}. In standard forward selection
(\code{MFKnockoffs.stat.forward_selection}), the next residual is the remainder after
regressing on the selected variable; when \emph{orthogonal matching pursuit}
is used (\code{MFKnockoffs.stat.forward_selection_omp}), the next residual is the remainder
after regressing on \emph{all} the previously selected variables.
}
\examples{
p=100; n=200; k=15
mu = rep(0,p); Sigma = diag(p)
X = matrix(rnorm(n*p),n)
nonzero = sample(p, k)
beta = 3.5 * (1:p \%in\% nonzero)
y = X \%*\% beta + rnorm(n)

# Basic usage with default arguments
knockoffs = function(X) MFKnockoffs.create.gaussian(X, mu, Sigma)
result = MFKnockoffs.filter(X, y, knockoffs=knockoffs,
                           statistic=MFKnockoffs.stat.forward_selection)
print(result$selected)

# Advanced usage with custom arguments
foo = MFKnockoffs.stat.forward_selection
k_stat = function(X, X_k, y) foo(X, X_k, y, omp=TRUE)
result = MFKnockoffs.filter(X, y, knockoffs=knockoffs, statistic=k_stat)
print(result$selected)

}
\seealso{
Other statistics for knockoffs: \code{\link{MFKnockoffs.stat.glmnet_coef_difference}},
  \code{\link{MFKnockoffs.stat.glmnet_lambda_difference}},
  \code{\link{MFKnockoffs.stat.lasso_coef_difference_bin}},
  \code{\link{MFKnockoffs.stat.lasso_coef_difference}},
  \code{\link{MFKnockoffs.stat.lasso_lambda_difference_bin}},
  \code{\link{MFKnockoffs.stat.lasso_lambda_difference}},
  \code{\link{MFKnockoffs.stat.random_forest}},
  \code{\link{MFKnockoffs.stat.sqrt_lasso}},
  \code{\link{MFKnockoffs.stat.stability_selection}}
}
