% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFPCAfit_methods.R
\name{predict.MFPCAfit}
\alias{predict.MFPCAfit}
\title{Function prediction based on MFPCA results}
\usage{
\method{predict}{MFPCAfit}(object, scores = object$scores, ...)
}
\arguments{
\item{object}{An object of class \code{MFPCAfit}, typically resulting from 
a \link{MFPCA} function call.}

\item{scores}{A matrix containing the score values. The number of columns in 
\code{scores} must equal the number of principal components in 
\code{object}. Each row represents one curve. Defaults to the estimated
scores in \code{object}, which yields reconstructions of the original
data used for the MFPCA calculation.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A \code{multiFunData} object containing the predicted functions.
}
\description{
Predict functions based on a truncated multivariate Karhunen-Loeve 
representation: \deqn{\hat x = \hat mu + \sum_{m = 1}^M \rho_m \hat \psi_m} 
with estimated mean function \eqn{\hat \mu} and principal components 
\eqn{\psi_m}. The scores \eqn{\rho_m} can be either estimated (reconstruction
of observed functions) or user-defined (construction of new functions).
}
\examples{
#' # Simulate multivariate functional data on one-dimensonal domains
# and calculate MFPCA (cf. MFPCA help)
set.seed(1)
# simulate data (one-dimensional domains)
sim <-  simMultiFunData(type = "split", argvals = list(seq(0,1,0.01), seq(-0.5,0.5,0.02)),
                       M = 5, eFunType = "Poly", eValType = "linear", N = 100)
# MFPCA based on univariate FPCA
PCA <- MFPCA(sim$simData, M = 5, uniExpansions = list(list(type = "uFPCA"),
                                                     list(type = "uFPCA")))

# Reconstruct the original data
pred <- predict(PCA) # default reconstructs data used for the MFPCA fit

# plot the results: 1st element
plot(sim$simData[[1]]) # original data
plot(pred[[1]], add = TRUE, lty = 2) # reconstruction

# plot the results: 2nd element
plot(sim$simData[[2]]) # original data
plot(pred[[2]], add = TRUE, lty = 2) # reconstruction
}
\seealso{
\link{MFPCA}
}
