% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GendataIM.R
\name{GendataIM}
\alias{GendataIM}
\title{Generate simulation data (Complete data for intersection variables)}
\usage{
GendataIM(n, p, rho, order = 2)
}
\arguments{
\item{n}{Number of subjects in the dataset to be simulated. It will also equal to the
number of rows in the dataset to be simulated, because it is assumed that each
row represents a different independent and identically distributed subject.}

\item{p}{Number of predictor variables (covariates) in the simulated dataset.
These covariates will be the features screened by model-free procedures.}

\item{rho}{The correlation between adjacent covariates in the simulated matrix X.
The within-subject covariance matrix of X is assumed to has the same form as an
AR(1) auto-regressive covariance matrix, although this is not meant to imply
that the X covariates for each subject are in fact a time series. Instead, it is just
used as an example of a parsimonious but nontrivial covariance structure. If
rho is left at the default of zero, the X covariates will be independent and the
simulation will run faster.}

\item{order}{The number of interactive variables and the default is 2.}
}
\value{
the list of your simulation data
}
\description{
This function helps you quickly generate simulation data based on transformation model.
You just need to input the sample and dimension of the data
you want to generate and the covariance parameter pho.
This simulated example comes from Section 4.2 introduced by Pan et al.(2019)
}
\examples{
n=100;
p=200;
rho=0.5;
data=GendataIM(n,p,rho)

}
\references{
Pan, W., X. Wang, W. Xiao, and H. Zhu (2019). A generic sure independence screening procedure. Journal of the American Statistical Association 114(526), 928–937.
}
\author{
Xuewei Cheng \email{xwcheng@csu.edu.cn}
}
