% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GendataPM.R
\name{GendataPM}
\alias{GendataPM}
\title{Generate simulation data (Discrete response data based on poisson model)}
\usage{
GendataPM(n, p, rho, beta = c(rep(1, 5), rep(0, p - 5)))
}
\arguments{
\item{n}{Number of subjects in the dataset to be simulated. It will also equal to the
number of rows in the dataset to be simulated, because it is assumed that each
row represents a different independent and identically distributed subject.}

\item{p}{Number of predictor variables (covariates) in the simulated dataset.
These covariates will be the features screened by model-free procedures.}

\item{rho}{The correlation between adjacent covariates in the simulated matrix X.
The within-subject covariance matrix of X is assumed to has the same form as an
AR(1) auto-regressive covariance matrix, although this is not meant to imply
that the X covariates for each subject are in fact a time series. Instead, it is just
used as an example of a parsimonious but nontrivial covariance structure. If
rho is left at the default of zero, the X covariates will be independent and the
simulation will run faster.}

\item{beta}{A vector with length of n, which are the coefficients that you want to generate
about Linear model. The default is beta=(1,1,1,1,1,0,...,0)^T;}
}
\value{
the list of your simulation data
}
\description{
This function helps you quickly generate simulation data based on poisson model.
You just need to input the sample and dimension of the data
you want to generate and the covariance parameter pho.
The simulated examples based on poisson model are significant popular
in the screening procedures, such as Model 1.f in Liu et al.(2020).
}
\examples{
n=100;
p=200;
rho=0.5;
data=GendataPM(n,p,rho)

}
\references{
Liu, W., Y. Ke, J. Liu, and R. Li (2020). Model-free feature screening and FDR control with knockoff features. Journal of the American Statistical Association, 1–16.
}
\author{
Xuewei Cheng \email{xwcheng@csu.edu.cn}
}
