% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcHurdleExpKernel}
\alias{calcHurdleExpKernel}
\title{Calculate Hurdle Exponential Stochastic Matrix}
\usage{
calcHurdleExpKernel(distMat, rate, pi)
}
\arguments{
\item{distMat}{distance matrix from \code{\link[MGDrivE]{calcVinEll}}}

\item{rate}{rate parameter of \code{\link[stats]{Exponential}} distribution}

\item{pi}{point mass at zero}
}
\description{
Given a distance matrix from \code{\link[MGDrivE]{calcVinEll}}, calculate a
stochastic matrix where one step movement probabilities follow an zero-truncated
exponential density with a point mass at zero.
}
\examples{
# setup distance matrix
# two-column matrix with latitude/longitude, in degrees
latLong = cbind(runif(n = 5, min = 0, max = 90),
                runif(n = 5, min = 0, max = 180))

# Vincenty Ellipsoid  distance formula
distMat = calcVinEll(latLongs = latLong)

# calculate hurdle exponential distribution over distances
#  rate and point mass are just for example
kernMat = calcHurdleExpKernel(distMat = distMat, rate = 10, pi = 1000)

}
