% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Network-Parameters.R
\name{parameterizeMGDrivE}
\alias{parameterizeMGDrivE}
\title{parameterizeMGDrivE}
\usage{
parameterizeMGDrivE(runID = 1L, nPatch, simTime, parallel = FALSE,
  moveVar = 1000, tEgg = 1L, tLarva = 14L, tPupa = 1L, beta = 32,
  muAd = 0.123, popGrowth = 1.096, AdPopEQ, LarPopRatio = NULL,
  AdPopRatio_F = NULL, AdPopRatio_M = NULL)
}
\arguments{
\item{runID}{begin counting runs with this set of parameters from this value}

\item{nPatch}{number of \code{\link{Patch}}}

\item{simTime}{maximum time to run simulation}

\item{parallel}{append process id (see \code{link[base]{Sys.getpid}}) to output files for running in parallel}

\item{moveVar}{variance of stochastic movement (not used in diffusion model of migration). It affects the concentration of probability in the Dirchlet simplex, small values lead to high variance and large values lead to low variance.}

\item{tEgg}{length of egg stage}

\item{tLarva}{length of larval instar stage}

\item{tPupa}{length of pupal stage}

\item{beta}{female egg batch size of wild-type}

\item{muAd}{wild-type daily adult mortality (1/muAd is average wild-type lifespan)}

\item{popGrowth}{daily population growth rate (used to calculate equilibrium)}

\item{AdPopEQ}{vector of adult population size at equilibrium}

\item{LarPopRatio}{may be \code{NULL}; if not, gives the wildtype gene frequencies among larval stages at the beginning of simulation}

\item{AdPopRatio_F}{may be \code{NULL}; if not, gives the wildtype gene frequencies among adult females at the beginning of simulation}

\item{AdPopRatio_M}{may be \code{NULL}; if not, gives the wildtype gene frequencies among adult males at the beginning of simulation}
}
\description{
Generate parameters for simulation on a \code{\link{Network}}.
Parameters average generation time \eqn{g}, population growth rate \eqn{R_{m}},
aquatic mortality \eqn{\mu_{Aq}}, and aquatic survival \eqn{\theta_{Aq}}
are shared between patches and calculated by \code{\link{calcAverageGenerationTime}},
\code{\link{calcPopulationGrowthRate}}, \code{\link{calcLarvalStageMortalityRate}},
and \code{\link{calcAquaticStagesSurvivalProbability}}. \cr
Patch-specific parameters \eqn{\alpha} and \eqn{L_{eq}}
are calculated for each patch by \code{\link{calcDensityDependentDeathRate}}
and \code{\link{calcLarvalPopEquilibrium}}.
}
\examples{
# using default parameters for 2 patches
#  using different population sizes for patches
simPars <- parameterizeMGDrivE(nPatch = 2, simTime = 365,
                               AdPopEQ = c(100,200))

}
