% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard-auxiliary.R
\name{calc_move_rate}
\alias{calc_move_rate}
\title{Calculate Outbound Movement Rate}
\usage{
calc_move_rate(mu, P)
}
\arguments{
\item{mu}{daily mortality rate}

\item{P}{cumulative probability to move before dying}
}
\value{
numeric probability of movement
}
\description{
Given \code{P}, the cumulative probability of moving before dying, and \code{mu},
the daily mortality rate, calculate the movement rate \code{gamma} to get \code{P}.
The equation comes from integrating the competing risks and solving for \code{gamma}.
}
\examples{
  # parameters, see vignette MGDrivE2: One Node Lifecycle Dynamics
  theta <- list(qE = 1/4, nE = 2, qL = 1/3, nL = 3, qP = 1/6, nP = 2,
                muE = 0.05, muL = 0.15, muP = 0.05, muF = 0.09, muM = 0.09,
                beta = 16, nu = 1/(4/24) )

  # lets say a 70\% chance to move over the entire lifespan
  rMoveRate <- calc_move_rate(mu = theta$muF, P = 0.70)

}
