% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard-auxiliary.R
\name{movement_prob2rate}
\alias{movement_prob2rate}
\title{Convert Stochastic Matrix to Rate Matrix}
\usage{
movement_prob2rate(tau)
}
\arguments{
\item{tau}{a row normalized stochastic matrix}
}
\value{
a list with two elements: \code{gamma} negative diagonal of the rate
matrix, \code{mat} matrix of row normalized off-diagonal elements
}
\description{
Given a stochastic matrix, return the rate matrix (infinitesimal generator)
that would generate it when exponentiated over the interval of unit time.
}
\details{
Warning: if the matrix provided has diagonal-only rows (i.e., the location is
independent), the rate matrix will return 0 in that row, as there is no movement
rate that can generate that scenario.
}
\examples{
  # generate random matrix for example
  #  This represents a 3-node landscape, with random movement between nodes
  moveMat <- matrix(data = runif(n = 9), nrow = 3, ncol = 3)
  moveMat <- moveMat/rowSums(moveMat)

  moveRate <- movement_prob2rate(tau = moveMat)

}
