% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetHpltTable_func_20200915.R
\name{GetHpltTable}
\alias{GetHpltTable}
\title{GetHpltTable() function}
\usage{
GetHpltTable(filepath)
}
\arguments{
\item{filepath}{is a user defined path to the folder where the output files
from the HpltFind() function have been saved.}
}
\value{
A table with the mean proportion of incongruent sequences for each
  nest.
}
\description{
\code{\link{GetHpltTable}} uses the output files produced by the HpltFind()
function to produce a table with the mean proportion of incongruent sequences
for each nest. If the mean proportion of incongruent sequences is generally
low, but certain nests have many incongruent sequences, biological reasons
may be causing the mismatches, e.g. extra-pair fertilizations or
recombination events.
}
\details{
If you publish data produced with MHCtools, please cite:
Roved, J. 2020. MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J., Hansson, B., Stervander, M., Hasselquist, D., Westerdahl, H. 2020.
Non-random association of MHC-I alleles in favor of high diversity haplotypes
in wild songbirds revealed by computer-assisted MHC haplotype inference using
the R package MHCtools. bioRxiv.
}
\examples{
filepath <- system.file("extdata/HpltFindOut/", package="MHCtools")
GetHpltTable(filepath)
}
\seealso{
\code{\link{HpltFind}}; \code{\link{GetHpltStats}}
}
