% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_actigraph_count_csv}
\alias{import_actigraph_count_csv}
\title{Import Actigraph count data stored in Actigraph summary csv format}
\usage{
import_actigraph_count_csv(
  filepath,
  count_col = 2,
  count_per_axis_cols = c(2, 3, 4)
)
}
\arguments{
\item{filepath}{string. The filepath of the input data.}

\item{count_col}{number. The index of column of Actigraph count (combined
axes). If it is \code{NULL}, the function will use
\code{count_per_axis_cols} to get the combined Actigraph count values.}

\item{count_per_axis_cols}{numerical vector. The indices of columns of
Actigraph count values per axis. If \code{count_col} is not \code{NULL},
the argument will be ignored. If it is \code{NULL}, the output dataframe
will only have two columns without Actigraph count values per axis.}
}
\value{
dataframe. The imported actigraph count data, with the first column
  being the timestamps in POSIXct format, and the second column being the
  combined Actigraph count values, and the rest of columns being the
  Actigraph cont values per axis if available. Column names:
  \code{HEADER_TIME_STAMP}, \code{ACTIGRAPH_COUNT},
  \code{ACTIGRAPH_COUNT_X}....
}
\description{
\code{import_actigraph_count_csv} imports Actigraph count data stored in
Actigraph summary csv format, which was exported by Actilife.
}
\note{
If both \code{count_col} and \code{count_per_axis_cols} are
  \code{NULL}, the function will raise an error.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a File IO
  function that is used to import Actigraph count data from Actigraph devices
  during algorithm validation.
}

\examples{
  # Use the actigraph count csv file shipped with the package
  filepath = system.file('extdata', 'actigraph_count.csv', package='MIMSunit')

  # Check original data format
  readLines(filepath)[1:5]

  # Load file, default column for actigraph count values are 2, this file does not have
  # axial count values
  output = import_actigraph_count_csv(filepath, count_col=2)

  # Check output
  head(output)
}
\seealso{
Other File I/O functions: 
\code{\link{export_to_actilife}()},
\code{\link{import_actigraph_csv_chunked}()},
\code{\link{import_actigraph_csv}()},
\code{\link{import_actigraph_meta}()},
\code{\link{import_activpal3_csv}()},
\code{\link{import_enmo_csv}()},
\code{\link{import_mhealth_csv_chunked}()},
\code{\link{import_mhealth_csv}()}
}
\concept{File I/O functions}
