% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{segment_data}
\alias{segment_data}
\title{Segment input dataframe into windows as specified by breaks.
\code{segment_data} segments the input sensor dataframe into
  epoch windows with length specified in breaks.}
\usage{
segment_data(df, breaks, st = NULL)
}
\arguments{
\item{df}{dataframe. Input dataframe of the multi-channel signal. The first
column is the timestamps in POSXlct format and the following columns are
accelerometer values.}

\item{breaks}{character. An epoch length character that can be accepted by
cut.breaks function.}

\item{st}{character or POSIXct timestamp. An optional start time you can set to
force the breaks generated by referencing this start time. If it is NULL, the
function will use the first timestamp in the timestamp column as start time to
generate breaks. This is useful when you are processing a stream of data and
want to use a common start time for segmenting data. Default is NULL.}
}
\value{
dataframe. The same format as the input dataframe, but with an extra
  column "SEGMENT" in the end specifies the epoch window a sample belongs to.
}
\description{
This function accepts a dataframe of multi-channel signal, segments it
  into epoch windows with length specified in breaks.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a utility
  function that was used in various part in the algorithm whenever we need to
  segment a dataframe, e.g., before aggregating values over epoch windows.
}

\examples{
  # Use sample data
  df = sample_raw_accel_data

  # segment data into 1 minute segments
  output = segment_data(df, "1 min")

  # check the 3rd segment, each segment would have 1 minute data
  summary(output[output['SEGMENT'] == 3,])

  # segment data into 15 second segments
  output = segment_data(df, "15 sec")

  # check the 1st segment, each segment would have 15 second data
  summary(output[output['SEGMENT'] == 1,])

  # segment data into 1 hour segments
  output = segment_data(df, "1 hour")

  # because the input data has only 15 minute data
  # there will be only 1 segment in the output
  unique(output['SEGMENT'])
  summary(output)

  # use manually set start time
  output = segment_data(df, "15 sec", st='2016-01-15 10:59:50.000')

  # check the 1st segment, because the start time is 10 seconds before the
  # start time of the actual data, the first segment will only include 5 second
  # data.
  summary(output[output['SEGMENT'] == 1,])
}
\seealso{
Other utility functions: 
\code{\link{clip_data}()},
\code{\link{cut_off_signal}()},
\code{\link{interpolate_signal}()},
\code{\link{parse_epoch_string}()},
\code{\link{sampling_rate}()},
\code{\link{simulate_new_data}()}
}
\concept{utility functions}
