// Generated by rstantools.  Do not edit by hand.

/*
    MIRES is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    MIRES is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MIRES.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_redifhm_multi_hier_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_redifhm_multi_hier");
    reader.add_event(1, 1, "include", "/functions/common.stan");
    reader.add_event(1, 0, "start", "/functions/common.stan");
    reader.add_event(40, 39, "end", "/functions/common.stan");
    reader.add_event(40, 2, "restart", "model_redifhm_multi_hier");
    reader.add_event(40, 2, "include", "/functions/md.stan");
    reader.add_event(40, 0, "start", "/functions/md.stan");
    reader.add_event(140, 100, "end", "/functions/md.stan");
    reader.add_event(140, 3, "restart", "model_redifhm_multi_hier");
    reader.add_event(297, 158, "end", "model_redifhm_multi_hier");
    return reader;
}
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
z_to_random(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& z,
                const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& sds,
                const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& L, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 11;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(z));
        current_statement_begin__ = 12;
        int num(0);
        (void) num;  // dummy to suppress unused var warning
        stan::math::fill(num, std::numeric_limits<int>::min());
        stan::math::assign(num,cols(z));
        current_statement_begin__ = 13;
        validate_non_negative_index("re", "K", K);
        validate_non_negative_index("re", "num", num);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> re(K, num);
        stan::math::initialize(re, DUMMY_VAR__);
        stan::math::fill(re, DUMMY_VAR__);
        stan::math::assign(re,multiply(z, transpose(diag_pre_multiply(sds, L))));
        current_statement_begin__ = 15;
        return stan::math::promote_scalar<fun_return_scalar_t__>(re);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct z_to_random_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& z,
                const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& sds,
                const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& L, std::ostream* pstream__) const {
        return z_to_random(z, sds, L, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, 1, Eigen::Dynamic>
compute_lambda_lowerbounds(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& lambda_random, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        int J(0);
        (void) J;  // dummy to suppress unused var warning
        stan::math::fill(J, std::numeric_limits<int>::min());
        stan::math::assign(J,cols(lambda_random));
        current_statement_begin__ = 28;
        validate_non_negative_index("lambda_lowerbound", "J", J);
        Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> lambda_lowerbound(J);
        stan::math::initialize(lambda_lowerbound, DUMMY_VAR__);
        stan::math::fill(lambda_lowerbound, DUMMY_VAR__);
        current_statement_begin__ = 30;
        for (int j = 1; j <= J; ++j) {
            current_statement_begin__ = 31;
            stan::model::assign(lambda_lowerbound, 
                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                        -(min(stan::model::rvalue(lambda_random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), "lambda_random"))), 
                        "assigning variable lambda_lowerbound");
        }
        current_statement_begin__ = 34;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lambda_lowerbound);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct compute_lambda_lowerbounds_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, 1, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& lambda_random, std::ostream* pstream__) const {
        return compute_lambda_lowerbounds(lambda_random, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
L_to_cor(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& L, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 39;
        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply_lower_tri_self_transpose(L));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct L_to_cor_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& L, std::ostream* pstream__) const {
        return L_to_cor(L, pstream__);
    }
};
std::vector<int>
gen_item_indices_md(const int& J,
                        const int& F,
                        const std::vector<int>& J_f,
                        const std::vector<std::vector<int> >& F_ind, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 49;
        int total_lambda(0);
        (void) total_lambda;  // dummy to suppress unused var warning
        stan::math::fill(total_lambda, std::numeric_limits<int>::min());
        stan::math::assign(total_lambda,sum(J_f));
        current_statement_begin__ = 50;
        validate_non_negative_index("resid_nu", "(2 * J)", (2 * J));
        std::vector<int  > resid_nu((2 * J), int(0));
        stan::math::fill(resid_nu, std::numeric_limits<int>::min());
        current_statement_begin__ = 51;
        validate_non_negative_index("lambda", "total_lambda", total_lambda);
        std::vector<int  > lambda(total_lambda, int(0));
        stan::math::fill(lambda, std::numeric_limits<int>::min());
        current_statement_begin__ = 52;
        validate_non_negative_index("lambda_resid_nu", "(total_lambda + (2 * J))", (total_lambda + (2 * J)));
        std::vector<int  > lambda_resid_nu((total_lambda + (2 * J)), int(0));
        stan::math::fill(lambda_resid_nu, std::numeric_limits<int>::min());
        current_statement_begin__ = 55;
        int base(0);
        (void) base;  // dummy to suppress unused var warning
        stan::math::fill(base, std::numeric_limits<int>::min());
        stan::math::assign(base,0);
        current_statement_begin__ = 56;
        for (int j = 1; j <= (2 * J); ++j) {
            current_statement_begin__ = 57;
            stan::model::assign(resid_nu, 
                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                        (j - base), 
                        "assigning variable resid_nu");
            current_statement_begin__ = 58;
            if (as_bool(logical_eq((j - base), J))) {
                current_statement_begin__ = 59;
                stan::math::assign(base, (base + J));
            }
        }
        current_statement_begin__ = 64;
        stan::math::assign(base, 1);
        current_statement_begin__ = 65;
        for (int f = 1; f <= F; ++f) {
            current_statement_begin__ = 66;
            stan::model::assign(lambda, 
                        stan::model::cons_list(stan::model::index_min_max(base, ((base - 1) + get_base1(J_f, f, "J_f", 1))), stan::model::nil_index_list()), 
                        stan::model::rvalue(F_ind, stan::model::cons_list(stan::model::index_uni(f), stan::model::cons_list(stan::model::index_min_max(1, get_base1(J_f, f, "J_f", 1)), stan::model::nil_index_list())), "F_ind"), 
                        "assigning variable lambda");
            current_statement_begin__ = 67;
            stan::math::assign(base, (base + get_base1(J_f, f, "J_f", 1)));
        }
        current_statement_begin__ = 71;
        stan::math::assign(lambda_resid_nu, append_array(lambda, resid_nu));
        current_statement_begin__ = 73;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lambda_resid_nu);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct gen_item_indices_md_functor__ {
            std::vector<int>
    operator()(const int& J,
                        const int& F,
                        const std::vector<int>& J_f,
                        const std::vector<std::vector<int> >& F_ind, std::ostream* pstream__) const {
        return gen_item_indices_md(J, F, J_f, F_ind, pstream__);
    }
};
std::vector<int>
gen_param_indices_md(const int& J,
                         const std::vector<int>& J_f, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 77;
        validate_non_negative_index("resid", "J", J);
        std::vector<int  > resid(J, int(0));
        stan::math::fill(resid, std::numeric_limits<int>::min());
        stan::math::assign(resid,rep_array(2, J));
        current_statement_begin__ = 78;
        validate_non_negative_index("nu", "J", J);
        std::vector<int  > nu(J, int(0));
        stan::math::fill(nu, std::numeric_limits<int>::min());
        stan::math::assign(nu,rep_array(3, J));
        current_statement_begin__ = 79;
        int lambda_total(0);
        (void) lambda_total;  // dummy to suppress unused var warning
        stan::math::fill(lambda_total, std::numeric_limits<int>::min());
        stan::math::assign(lambda_total,sum(J_f));
        current_statement_begin__ = 80;
        validate_non_negative_index("lambda", "lambda_total", lambda_total);
        std::vector<int  > lambda(lambda_total, int(0));
        stan::math::fill(lambda, std::numeric_limits<int>::min());
        stan::math::assign(lambda,rep_array(1, lambda_total));
        current_statement_begin__ = 81;
        validate_non_negative_index("lambda_resid_nu", "(lambda_total + (2 * J))", (lambda_total + (2 * J)));
        std::vector<int  > lambda_resid_nu((lambda_total + (2 * J)), int(0));
        stan::math::fill(lambda_resid_nu, std::numeric_limits<int>::min());
        stan::math::assign(lambda_resid_nu,append_array(lambda, append_array(resid, nu)));
        current_statement_begin__ = 83;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lambda_resid_nu);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct gen_param_indices_md_functor__ {
            std::vector<int>
    operator()(const int& J,
                         const std::vector<int>& J_f, std::ostream* pstream__) const {
        return gen_param_indices_md(J, J_f, pstream__);
    }
};
std::vector<std::vector<int> >
gen_lamResNu_bounds(const int& J,
                        const std::vector<int>& J_f, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 94;
        validate_non_negative_index("out", "3", 3);
        validate_non_negative_index("out", "2", 2);
        std::vector<std::vector<int  >  > out(3, std::vector<int>(2, int(0)));
        stan::math::fill(out, std::numeric_limits<int>::min());
        current_statement_begin__ = 95;
        int lambda_total(0);
        (void) lambda_total;  // dummy to suppress unused var warning
        stan::math::fill(lambda_total, std::numeric_limits<int>::min());
        stan::math::assign(lambda_total,sum(J_f));
        current_statement_begin__ = 96;
        stan::model::assign(out, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    static_cast<std::vector<int> >(stan::math::array_builder<int >().add(1).add(lambda_total).array()), 
                    "assigning variable out");
        current_statement_begin__ = 97;
        stan::model::assign(out, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                    static_cast<std::vector<int> >(stan::math::array_builder<int >().add((lambda_total + 1)).add((lambda_total + J)).array()), 
                    "assigning variable out");
        current_statement_begin__ = 98;
        stan::model::assign(out, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                    static_cast<std::vector<int> >(stan::math::array_builder<int >().add(((lambda_total + J) + 1)).add((lambda_total + (2 * J))).array()), 
                    "assigning variable out");
        current_statement_begin__ = 100;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct gen_lamResNu_bounds_functor__ {
            std::vector<std::vector<int> >
    operator()(const int& J,
                        const std::vector<int>& J_f, std::ostream* pstream__) const {
        return gen_lamResNu_bounds(J, J_f, pstream__);
    }
};
template <typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
lambda_mat(const std::vector<int>& J_f,
               const std::vector<std::vector<int> >& F_ind,
               const Eigen::Matrix<T2__, 1, Eigen::Dynamic>& lambdaEst, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 104;
        validate_non_negative_index("F_J", "2", 2);
        std::vector<int  > F_J(2, int(0));
        stan::math::fill(F_J, std::numeric_limits<int>::min());
        stan::math::assign(F_J,dims(F_ind));
        current_statement_begin__ = 105;
        int F(0);
        (void) F;  // dummy to suppress unused var warning
        stan::math::fill(F, std::numeric_limits<int>::min());
        stan::math::assign(F,get_base1(F_J, 1, "F_J", 1));
        current_statement_begin__ = 106;
        int J(0);
        (void) J;  // dummy to suppress unused var warning
        stan::math::fill(J, std::numeric_limits<int>::min());
        stan::math::assign(J,get_base1(F_J, 2, "F_J", 1));
        current_statement_begin__ = 107;
        int tot(0);
        (void) tot;  // dummy to suppress unused var warning
        stan::math::fill(tot, std::numeric_limits<int>::min());
        stan::math::assign(tot,sum(J_f));
        current_statement_begin__ = 108;
        validate_non_negative_index("lambda", "F", F);
        validate_non_negative_index("lambda", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> lambda(F, J);
        stan::math::initialize(lambda, DUMMY_VAR__);
        stan::math::fill(lambda, DUMMY_VAR__);
        stan::math::assign(lambda,rep_matrix(rep_vector(0.0, F), J));
        current_statement_begin__ = 110;
        int count(0);
        (void) count;  // dummy to suppress unused var warning
        stan::math::fill(count, std::numeric_limits<int>::min());
        stan::math::assign(count,1);
        current_statement_begin__ = 111;
        for (int f = 1; f <= F; ++f) {
            current_statement_begin__ = 112;
            for (auto& jj : stan::model::rvalue(F_ind, stan::model::cons_list(stan::model::index_uni(f), stan::model::cons_list(stan::model::index_min_max(1, get_base1(J_f, f, "J_f", 1)), stan::model::nil_index_list())), "F_ind")) {
                (void) jj;  // dummy to suppress unused var warning
                current_statement_begin__ = 113;
                stan::model::assign(lambda, 
                            stan::model::cons_list(stan::model::index_uni(f), stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list())), 
                            get_base1(lambdaEst, count, "lambdaEst", 1), 
                            "assigning variable lambda");
                current_statement_begin__ = 114;
                stan::math::assign(count, (count + 1));
            }
        }
        current_statement_begin__ = 118;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lambda);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct lambda_mat_functor__ {
    template <typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const std::vector<int>& J_f,
               const std::vector<std::vector<int> >& F_ind,
               const Eigen::Matrix<T2__, 1, Eigen::Dynamic>& lambdaEst, std::ostream* pstream__) const {
        return lambda_mat(J_f, F_ind, lambdaEst, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
convex_combine_Ls(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& L1,
                      const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& L2,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& weight_L2, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 130;
        int R(0);
        (void) R;  // dummy to suppress unused var warning
        stan::math::fill(R, std::numeric_limits<int>::min());
        stan::math::assign(R,rows(L1));
        current_statement_begin__ = 131;
        int C(0);
        (void) C;  // dummy to suppress unused var warning
        stan::math::fill(C, std::numeric_limits<int>::min());
        stan::math::assign(C,cols(L1));
        current_statement_begin__ = 132;
        validate_non_negative_index("LL1", "R", R);
        validate_non_negative_index("LL1", "C", C);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> LL1(R, C);
        stan::math::initialize(LL1, DUMMY_VAR__);
        stan::math::fill(LL1, DUMMY_VAR__);
        stan::math::assign(LL1,multiply_lower_tri_self_transpose(L1));
        current_statement_begin__ = 133;
        validate_non_negative_index("LL2", "R", R);
        validate_non_negative_index("LL2", "C", C);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> LL2(R, C);
        stan::math::initialize(LL2, DUMMY_VAR__);
        stan::math::fill(LL2, DUMMY_VAR__);
        stan::math::assign(LL2,multiply_lower_tri_self_transpose(L2));
        current_statement_begin__ = 134;
        validate_non_negative_index("outLL", "R", R);
        validate_non_negative_index("outLL", "C", C);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> outLL(R, C);
        stan::math::initialize(outLL, DUMMY_VAR__);
        stan::math::fill(outLL, DUMMY_VAR__);
        stan::math::assign(outLL,add(multiply((1 - get_base1(weight_L2, 1, "weight_L2", 1)), LL1), multiply(get_base1(weight_L2, 1, "weight_L2", 1), LL2)));
        current_statement_begin__ = 136;
        validate_non_negative_index("outL", "R", R);
        validate_non_negative_index("outL", "C", C);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> outL(R, C);
        stan::math::initialize(outL, DUMMY_VAR__);
        stan::math::fill(outL, DUMMY_VAR__);
        stan::math::assign(outL,cholesky_decompose(outLL));
        current_statement_begin__ = 138;
        return stan::math::promote_scalar<fun_return_scalar_t__>(outL);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convex_combine_Ls_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& L1,
                      const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& L2,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& weight_L2, std::ostream* pstream__) const {
        return convex_combine_Ls(L1, L2, weight_L2, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_redifhm_multi_hier
  : public stan::model::model_base_crtp<model_redifhm_multi_hier> {
private:
        int N;
        int J;
        int K;
        int F;
        std::vector<int> group;
        matrix_d x;
        std::vector<int> J_f;
        std::vector<std::vector<int> > F_ind;
        int prior_only;
        int eta_cor_nonmi;
        double hmre_mu;
        double hmre_scale;
        int total_lambda;
        int total_param;
        std::vector<int> hm_item_index;
        std::vector<int> hm_param_index;
        std::vector<std::vector<int> > lamResNu_bounds;
        vector_d x_vector;
public:
    model_redifhm_multi_hier(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_redifhm_multi_hier(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_redifhm_multi_hier_namespace::model_redifhm_multi_hier";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 145;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 146;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 147;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 148;
            context__.validate_dims("data initialization", "F", "int", context__.to_vec());
            F = int(0);
            vals_i__ = context__.vals_i("F");
            pos__ = 0;
            F = vals_i__[pos__++];
            current_statement_begin__ = 150;
            validate_non_negative_index("group", "N", N);
            context__.validate_dims("data initialization", "group", "int", context__.to_vec(N));
            group = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("group");
            pos__ = 0;
            size_t group_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < group_k_0_max__; ++k_0__) {
                group[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 152;
            validate_non_negative_index("x", "N", N);
            validate_non_negative_index("x", "J", J);
            context__.validate_dims("data initialization", "x", "matrix_d", context__.to_vec(N,J));
            x = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, J);
            vals_r__ = context__.vals_r("x");
            pos__ = 0;
            size_t x_j_2_max__ = J;
            size_t x_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < x_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_j_1_max__; ++j_1__) {
                    x(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 154;
            validate_non_negative_index("J_f", "F", F);
            context__.validate_dims("data initialization", "J_f", "int", context__.to_vec(F));
            J_f = std::vector<int>(F, int(0));
            vals_i__ = context__.vals_i("J_f");
            pos__ = 0;
            size_t J_f_k_0_max__ = F;
            for (size_t k_0__ = 0; k_0__ < J_f_k_0_max__; ++k_0__) {
                J_f[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 155;
            validate_non_negative_index("F_ind", "F", F);
            validate_non_negative_index("F_ind", "J", J);
            context__.validate_dims("data initialization", "F_ind", "int", context__.to_vec(F,J));
            F_ind = std::vector<std::vector<int> >(F, std::vector<int>(J, int(0)));
            vals_i__ = context__.vals_i("F_ind");
            pos__ = 0;
            size_t F_ind_k_0_max__ = F;
            size_t F_ind_k_1_max__ = J;
            for (size_t k_1__ = 0; k_1__ < F_ind_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < F_ind_k_0_max__; ++k_0__) {
                    F_ind[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 158;
            context__.validate_dims("data initialization", "prior_only", "int", context__.to_vec());
            prior_only = int(0);
            vals_i__ = context__.vals_i("prior_only");
            pos__ = 0;
            prior_only = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_only", prior_only, 0);
            check_less_or_equal(function__, "prior_only", prior_only, 1);
            current_statement_begin__ = 159;
            context__.validate_dims("data initialization", "eta_cor_nonmi", "int", context__.to_vec());
            eta_cor_nonmi = int(0);
            vals_i__ = context__.vals_i("eta_cor_nonmi");
            pos__ = 0;
            eta_cor_nonmi = vals_i__[pos__++];
            check_greater_or_equal(function__, "eta_cor_nonmi", eta_cor_nonmi, 0);
            check_less_or_equal(function__, "eta_cor_nonmi", eta_cor_nonmi, 1);
            current_statement_begin__ = 160;
            context__.validate_dims("data initialization", "hmre_mu", "double", context__.to_vec());
            hmre_mu = double(0);
            vals_r__ = context__.vals_r("hmre_mu");
            pos__ = 0;
            hmre_mu = vals_r__[pos__++];
            current_statement_begin__ = 161;
            context__.validate_dims("data initialization", "hmre_scale", "double", context__.to_vec());
            hmre_scale = double(0);
            vals_r__ = context__.vals_r("hmre_scale");
            pos__ = 0;
            hmre_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "hmre_scale", hmre_scale, 0);
            // initialize transformed data variables
            current_statement_begin__ = 166;
            total_lambda = int(0);
            stan::math::fill(total_lambda, std::numeric_limits<int>::min());
            stan::math::assign(total_lambda,sum(J_f));
            current_statement_begin__ = 167;
            total_param = int(0);
            stan::math::fill(total_param, std::numeric_limits<int>::min());
            stan::math::assign(total_param,(total_lambda + (2 * J)));
            current_statement_begin__ = 169;
            validate_non_negative_index("hm_item_index", "total_param", total_param);
            hm_item_index = std::vector<int>(total_param, int(0));
            stan::math::fill(hm_item_index, std::numeric_limits<int>::min());
            stan::math::assign(hm_item_index,gen_item_indices_md(J, F, J_f, F_ind, pstream__));
            current_statement_begin__ = 170;
            validate_non_negative_index("hm_param_index", "total_param", total_param);
            hm_param_index = std::vector<int>(total_param, int(0));
            stan::math::fill(hm_param_index, std::numeric_limits<int>::min());
            stan::math::assign(hm_param_index,gen_param_indices_md(J, J_f, pstream__));
            current_statement_begin__ = 171;
            validate_non_negative_index("lamResNu_bounds", "3", 3);
            validate_non_negative_index("lamResNu_bounds", "2", 2);
            lamResNu_bounds = std::vector<std::vector<int> >(3, std::vector<int>(2, int(0)));
            stan::math::fill(lamResNu_bounds, std::numeric_limits<int>::min());
            stan::math::assign(lamResNu_bounds,gen_lamResNu_bounds(J, J_f, pstream__));
            current_statement_begin__ = 173;
            validate_non_negative_index("x_vector", "(N * J)", (N * J));
            x_vector = Eigen::Matrix<double, Eigen::Dynamic, 1>((N * J));
            stan::math::fill(x_vector, DUMMY_VAR__);
            stan::math::assign(x_vector,to_vector(x));
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 179;
            validate_non_negative_index("lambda_log_est", "total_lambda", total_lambda);
            num_params_r__ += total_lambda;
            current_statement_begin__ = 180;
            validate_non_negative_index("nu", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 181;
            validate_non_negative_index("resid_log", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 184;
            validate_non_negative_index("random_z", "K", K);
            validate_non_negative_index("random_z", "(total_param + (2 * F))", (total_param + (2 * F)));
            num_params_r__ += (K * (total_param + (2 * F)));
            current_statement_begin__ = 185;
            validate_non_negative_index("random_L", "(total_param + (2 * F))", (total_param + (2 * F)));
            validate_non_negative_index("random_L", "(total_param + (2 * F))", (total_param + (2 * F)));
            num_params_r__ += (((total_param + (2 * F)) * ((total_param + (2 * F)) - 1)) / 2);
            current_statement_begin__ = 186;
            validate_non_negative_index("random_sigma", "(total_param + (2 * F))", (total_param + (2 * F)));
            num_params_r__ += (total_param + (2 * F));
            current_statement_begin__ = 189;
            validate_non_negative_index("eta_z", "N", N);
            validate_non_negative_index("eta_z", "F", F);
            num_params_r__ += (N * F);
            current_statement_begin__ = 190;
            validate_non_negative_index("eta_L_fixed", "F", F);
            validate_non_negative_index("eta_L_fixed", "F", F);
            num_params_r__ += ((F * (F - 1)) / 2);
            current_statement_begin__ = 192;
            validate_non_negative_index("eta_L_random", "F", F);
            validate_non_negative_index("eta_L_random", "F", F);
            validate_non_negative_index("eta_L_random", "(K * eta_cor_nonmi)", (K * eta_cor_nonmi));
            num_params_r__ += (((F * (F - 1)) / 2) * (K * eta_cor_nonmi));
            current_statement_begin__ = 193;
            validate_non_negative_index("eta_L_random_weight", "eta_cor_nonmi", eta_cor_nonmi);
            num_params_r__ += eta_cor_nonmi;
            current_statement_begin__ = 197;
            num_params_r__ += 1;
            current_statement_begin__ = 198;
            validate_non_negative_index("hm_param", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 199;
            validate_non_negative_index("hm_item", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 200;
            validate_non_negative_index("hm_lambda", "total_param", total_param);
            num_params_r__ += total_param;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_redifhm_multi_hier() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 179;
        if (!(context__.contains_r("lambda_log_est")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_log_est missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_log_est");
        pos__ = 0U;
        validate_non_negative_index("lambda_log_est", "total_lambda", total_lambda);
        context__.validate_dims("parameter initialization", "lambda_log_est", "row_vector_d", context__.to_vec(total_lambda));
        Eigen::Matrix<double, 1, Eigen::Dynamic> lambda_log_est(total_lambda);
        size_t lambda_log_est_j_1_max__ = total_lambda;
        for (size_t j_1__ = 0; j_1__ < lambda_log_est_j_1_max__; ++j_1__) {
            lambda_log_est(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(lambda_log_est);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_log_est: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 180;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        validate_non_negative_index("nu", "J", J);
        context__.validate_dims("parameter initialization", "nu", "row_vector_d", context__.to_vec(J));
        Eigen::Matrix<double, 1, Eigen::Dynamic> nu(J);
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            nu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 181;
        if (!(context__.contains_r("resid_log")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable resid_log missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("resid_log");
        pos__ = 0U;
        validate_non_negative_index("resid_log", "J", J);
        context__.validate_dims("parameter initialization", "resid_log", "row_vector_d", context__.to_vec(J));
        Eigen::Matrix<double, 1, Eigen::Dynamic> resid_log(J);
        size_t resid_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < resid_log_j_1_max__; ++j_1__) {
            resid_log(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(resid_log);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable resid_log: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 184;
        if (!(context__.contains_r("random_z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable random_z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("random_z");
        pos__ = 0U;
        validate_non_negative_index("random_z", "K", K);
        validate_non_negative_index("random_z", "(total_param + (2 * F))", (total_param + (2 * F)));
        context__.validate_dims("parameter initialization", "random_z", "matrix_d", context__.to_vec(K,(total_param + (2 * F))));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> random_z(K, (total_param + (2 * F)));
        size_t random_z_j_2_max__ = (total_param + (2 * F));
        size_t random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_z_j_1_max__; ++j_1__) {
                random_z(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(random_z);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable random_z: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 185;
        if (!(context__.contains_r("random_L")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable random_L missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("random_L");
        pos__ = 0U;
        validate_non_negative_index("random_L", "(total_param + (2 * F))", (total_param + (2 * F)));
        validate_non_negative_index("random_L", "(total_param + (2 * F))", (total_param + (2 * F)));
        context__.validate_dims("parameter initialization", "random_L", "matrix_d", context__.to_vec((total_param + (2 * F)),(total_param + (2 * F))));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> random_L((total_param + (2 * F)), (total_param + (2 * F)));
        size_t random_L_j_2_max__ = (total_param + (2 * F));
        size_t random_L_j_1_max__ = (total_param + (2 * F));
        for (size_t j_2__ = 0; j_2__ < random_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_L_j_1_max__; ++j_1__) {
                random_L(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cholesky_factor_corr_unconstrain(random_L);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable random_L: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 186;
        if (!(context__.contains_r("random_sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable random_sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("random_sigma");
        pos__ = 0U;
        validate_non_negative_index("random_sigma", "(total_param + (2 * F))", (total_param + (2 * F)));
        context__.validate_dims("parameter initialization", "random_sigma", "vector_d", context__.to_vec((total_param + (2 * F))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> random_sigma((total_param + (2 * F)));
        size_t random_sigma_j_1_max__ = (total_param + (2 * F));
        for (size_t j_1__ = 0; j_1__ < random_sigma_j_1_max__; ++j_1__) {
            random_sigma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, random_sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable random_sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 189;
        if (!(context__.contains_r("eta_z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta_z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta_z");
        pos__ = 0U;
        validate_non_negative_index("eta_z", "N", N);
        validate_non_negative_index("eta_z", "F", F);
        context__.validate_dims("parameter initialization", "eta_z", "matrix_d", context__.to_vec(N,F));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eta_z(N, F);
        size_t eta_z_j_2_max__ = F;
        size_t eta_z_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < eta_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_z_j_1_max__; ++j_1__) {
                eta_z(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(eta_z);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta_z: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 190;
        if (!(context__.contains_r("eta_L_fixed")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta_L_fixed missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta_L_fixed");
        pos__ = 0U;
        validate_non_negative_index("eta_L_fixed", "F", F);
        validate_non_negative_index("eta_L_fixed", "F", F);
        context__.validate_dims("parameter initialization", "eta_L_fixed", "matrix_d", context__.to_vec(F,F));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eta_L_fixed(F, F);
        size_t eta_L_fixed_j_2_max__ = F;
        size_t eta_L_fixed_j_1_max__ = F;
        for (size_t j_2__ = 0; j_2__ < eta_L_fixed_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_L_fixed_j_1_max__; ++j_1__) {
                eta_L_fixed(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cholesky_factor_corr_unconstrain(eta_L_fixed);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta_L_fixed: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 192;
        if (!(context__.contains_r("eta_L_random")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta_L_random missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta_L_random");
        pos__ = 0U;
        validate_non_negative_index("eta_L_random", "F", F);
        validate_non_negative_index("eta_L_random", "F", F);
        validate_non_negative_index("eta_L_random", "(K * eta_cor_nonmi)", (K * eta_cor_nonmi));
        context__.validate_dims("parameter initialization", "eta_L_random", "matrix_d", context__.to_vec((K * eta_cor_nonmi),F,F));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > eta_L_random((K * eta_cor_nonmi), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(F, F));
        size_t eta_L_random_j_2_max__ = F;
        size_t eta_L_random_j_1_max__ = F;
        size_t eta_L_random_k_0_max__ = (K * eta_cor_nonmi);
        for (size_t j_2__ = 0; j_2__ < eta_L_random_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_L_random_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < eta_L_random_k_0_max__; ++k_0__) {
                    eta_L_random[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t eta_L_random_i_0_max__ = (K * eta_cor_nonmi);
        for (size_t i_0__ = 0; i_0__ < eta_L_random_i_0_max__; ++i_0__) {
            try {
                writer__.cholesky_factor_corr_unconstrain(eta_L_random[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta_L_random: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 193;
        if (!(context__.contains_r("eta_L_random_weight")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta_L_random_weight missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta_L_random_weight");
        pos__ = 0U;
        validate_non_negative_index("eta_L_random_weight", "eta_cor_nonmi", eta_cor_nonmi);
        context__.validate_dims("parameter initialization", "eta_L_random_weight", "vector_d", context__.to_vec(eta_cor_nonmi));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta_L_random_weight(eta_cor_nonmi);
        size_t eta_L_random_weight_j_1_max__ = eta_cor_nonmi;
        for (size_t j_1__ = 0; j_1__ < eta_L_random_weight_j_1_max__; ++j_1__) {
            eta_L_random_weight(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, eta_L_random_weight);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta_L_random_weight: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 197;
        if (!(context__.contains_r("hm_tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hm_tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hm_tau");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "hm_tau", "double", context__.to_vec());
        double hm_tau(0);
        hm_tau = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(hm_tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hm_tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 198;
        if (!(context__.contains_r("hm_param")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hm_param missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hm_param");
        pos__ = 0U;
        validate_non_negative_index("hm_param", "3", 3);
        context__.validate_dims("parameter initialization", "hm_param", "vector_d", context__.to_vec(3));
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_param(3);
        size_t hm_param_j_1_max__ = 3;
        for (size_t j_1__ = 0; j_1__ < hm_param_j_1_max__; ++j_1__) {
            hm_param(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(hm_param);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hm_param: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 199;
        if (!(context__.contains_r("hm_item")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hm_item missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hm_item");
        pos__ = 0U;
        validate_non_negative_index("hm_item", "J", J);
        context__.validate_dims("parameter initialization", "hm_item", "vector_d", context__.to_vec(J));
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_item(J);
        size_t hm_item_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < hm_item_j_1_max__; ++j_1__) {
            hm_item(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(hm_item);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hm_item: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 200;
        if (!(context__.contains_r("hm_lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hm_lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hm_lambda");
        pos__ = 0U;
        validate_non_negative_index("hm_lambda", "total_param", total_param);
        context__.validate_dims("parameter initialization", "hm_lambda", "vector_d", context__.to_vec(total_param));
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_lambda(total_param);
        size_t hm_lambda_j_1_max__ = total_param;
        for (size_t j_1__ = 0; j_1__ < hm_lambda_j_1_max__; ++j_1__) {
            hm_lambda(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(hm_lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hm_lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 179;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> lambda_log_est;
            (void) lambda_log_est;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_log_est = in__.row_vector_constrain(total_lambda, lp__);
            else
                lambda_log_est = in__.row_vector_constrain(total_lambda);
            current_statement_begin__ = 180;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.row_vector_constrain(J, lp__);
            else
                nu = in__.row_vector_constrain(J);
            current_statement_begin__ = 181;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> resid_log;
            (void) resid_log;  // dummy to suppress unused var warning
            if (jacobian__)
                resid_log = in__.row_vector_constrain(J, lp__);
            else
                resid_log = in__.row_vector_constrain(J);
            current_statement_begin__ = 184;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> random_z;
            (void) random_z;  // dummy to suppress unused var warning
            if (jacobian__)
                random_z = in__.matrix_constrain(K, (total_param + (2 * F)), lp__);
            else
                random_z = in__.matrix_constrain(K, (total_param + (2 * F)));
            current_statement_begin__ = 185;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> random_L;
            (void) random_L;  // dummy to suppress unused var warning
            if (jacobian__)
                random_L = in__.cholesky_factor_corr_constrain((total_param + (2 * F)), lp__);
            else
                random_L = in__.cholesky_factor_corr_constrain((total_param + (2 * F)));
            current_statement_begin__ = 186;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> random_sigma;
            (void) random_sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                random_sigma = in__.vector_lb_constrain(0, (total_param + (2 * F)), lp__);
            else
                random_sigma = in__.vector_lb_constrain(0, (total_param + (2 * F)));
            current_statement_begin__ = 189;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> eta_z;
            (void) eta_z;  // dummy to suppress unused var warning
            if (jacobian__)
                eta_z = in__.matrix_constrain(N, F, lp__);
            else
                eta_z = in__.matrix_constrain(N, F);
            current_statement_begin__ = 190;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> eta_L_fixed;
            (void) eta_L_fixed;  // dummy to suppress unused var warning
            if (jacobian__)
                eta_L_fixed = in__.cholesky_factor_corr_constrain(F, lp__);
            else
                eta_L_fixed = in__.cholesky_factor_corr_constrain(F);
            current_statement_begin__ = 192;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > eta_L_random;
            size_t eta_L_random_d_0_max__ = (K * eta_cor_nonmi);
            eta_L_random.reserve(eta_L_random_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < eta_L_random_d_0_max__; ++d_0__) {
                if (jacobian__)
                    eta_L_random.push_back(in__.cholesky_factor_corr_constrain(F, lp__));
                else
                    eta_L_random.push_back(in__.cholesky_factor_corr_constrain(F));
            }
            current_statement_begin__ = 193;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_L_random_weight;
            (void) eta_L_random_weight;  // dummy to suppress unused var warning
            if (jacobian__)
                eta_L_random_weight = in__.vector_lub_constrain(0, 1, eta_cor_nonmi, lp__);
            else
                eta_L_random_weight = in__.vector_lub_constrain(0, 1, eta_cor_nonmi);
            current_statement_begin__ = 197;
            local_scalar_t__ hm_tau;
            (void) hm_tau;  // dummy to suppress unused var warning
            if (jacobian__)
                hm_tau = in__.scalar_constrain(lp__);
            else
                hm_tau = in__.scalar_constrain();
            current_statement_begin__ = 198;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> hm_param;
            (void) hm_param;  // dummy to suppress unused var warning
            if (jacobian__)
                hm_param = in__.vector_constrain(3, lp__);
            else
                hm_param = in__.vector_constrain(3);
            current_statement_begin__ = 199;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> hm_item;
            (void) hm_item;  // dummy to suppress unused var warning
            if (jacobian__)
                hm_item = in__.vector_constrain(J, lp__);
            else
                hm_item = in__.vector_constrain(J);
            current_statement_begin__ = 200;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> hm_lambda;
            (void) hm_lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                hm_lambda = in__.vector_constrain(total_param, lp__);
            else
                hm_lambda = in__.vector_constrain(total_param);
            // transformed parameters
            current_statement_begin__ = 209;
            validate_non_negative_index("random", "K", K);
            validate_non_negative_index("random", "(total_param + (2 * F))", (total_param + (2 * F)));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> random(K, (total_param + (2 * F)));
            stan::math::initialize(random, DUMMY_VAR__);
            stan::math::fill(random, DUMMY_VAR__);
            stan::math::assign(random,z_to_random(random_z, random_sigma, random_L, pstream__));
            current_statement_begin__ = 210;
            validate_non_negative_index("lambda_est_random", "K", K);
            validate_non_negative_index("lambda_est_random", "total_lambda", total_lambda);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> lambda_est_random(K, total_lambda);
            stan::math::initialize(lambda_est_random, DUMMY_VAR__);
            stan::math::fill(lambda_est_random, DUMMY_VAR__);
            stan::math::assign(lambda_est_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(get_base1(get_base1(lamResNu_bounds, 1, "lamResNu_bounds", 1), 1, "lamResNu_bounds", 2), get_base1(get_base1(lamResNu_bounds, 1, "lamResNu_bounds", 1), 2, "lamResNu_bounds", 2)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 211;
            validate_non_negative_index("resid_random", "K", K);
            validate_non_negative_index("resid_random", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> resid_random(K, J);
            stan::math::initialize(resid_random, DUMMY_VAR__);
            stan::math::fill(resid_random, DUMMY_VAR__);
            stan::math::assign(resid_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(get_base1(get_base1(lamResNu_bounds, 2, "lamResNu_bounds", 1), 1, "lamResNu_bounds", 2), get_base1(get_base1(lamResNu_bounds, 2, "lamResNu_bounds", 1), 2, "lamResNu_bounds", 2)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 212;
            validate_non_negative_index("nu_random", "K", K);
            validate_non_negative_index("nu_random", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> nu_random(K, J);
            stan::math::initialize(nu_random, DUMMY_VAR__);
            stan::math::fill(nu_random, DUMMY_VAR__);
            stan::math::assign(nu_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(get_base1(get_base1(lamResNu_bounds, 3, "lamResNu_bounds", 1), 1, "lamResNu_bounds", 2), get_base1(get_base1(lamResNu_bounds, 3, "lamResNu_bounds", 1), 2, "lamResNu_bounds", 2)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 213;
            validate_non_negative_index("eta_mean", "K", K);
            validate_non_negative_index("eta_mean", "F", F);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> eta_mean(K, F);
            stan::math::initialize(eta_mean, DUMMY_VAR__);
            stan::math::fill(eta_mean, DUMMY_VAR__);
            stan::math::assign(eta_mean,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max((get_base1(get_base1(lamResNu_bounds, 3, "lamResNu_bounds", 1), 2, "lamResNu_bounds", 2) + 1), (get_base1(get_base1(lamResNu_bounds, 3, "lamResNu_bounds", 1), 2, "lamResNu_bounds", 2) + F)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 214;
            validate_non_negative_index("eta_sd", "K", K);
            validate_non_negative_index("eta_sd", "F", F);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> eta_sd(K, F);
            stan::math::initialize(eta_sd, DUMMY_VAR__);
            stan::math::fill(eta_sd, DUMMY_VAR__);
            stan::math::assign(eta_sd,stan::math::exp(stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(((total_param + F) + 1), (total_param + (2 * F))), stan::model::nil_index_list())), "random")));
            current_statement_begin__ = 215;
            validate_non_negative_index("eta_cov_U", "(2 * F)", (2 * F));
            validate_non_negative_index("eta_cov_U", "(2 * F)", (2 * F));
            validate_non_negative_index("eta_cov_U", "K", K);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > eta_cov_U(K, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>((2 * F), (2 * F)));
            stan::math::initialize(eta_cov_U, DUMMY_VAR__);
            stan::math::fill(eta_cov_U, DUMMY_VAR__);
            current_statement_begin__ = 216;
            validate_non_negative_index("eta", "N", N);
            validate_non_negative_index("eta", "F", F);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> eta(N, F);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            stan::math::assign(eta,stan::model::rvalue(eta_mean, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "eta_mean"));
            current_statement_begin__ = 217;
            validate_non_negative_index("lambda_lowerbound", "total_lambda", total_lambda);
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> lambda_lowerbound(total_lambda);
            stan::math::initialize(lambda_lowerbound, DUMMY_VAR__);
            stan::math::fill(lambda_lowerbound, DUMMY_VAR__);
            stan::math::assign(lambda_lowerbound,compute_lambda_lowerbounds(lambda_est_random, pstream__));
            current_statement_begin__ = 218;
            validate_non_negative_index("lambda_est", "total_lambda", total_lambda);
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> lambda_est(total_lambda);
            stan::math::initialize(lambda_est, DUMMY_VAR__);
            stan::math::fill(lambda_est, DUMMY_VAR__);
            stan::math::assign(lambda_est,add(stan::math::exp(lambda_log_est), lambda_lowerbound));
            current_statement_begin__ = 219;
            validate_non_negative_index("lambda", "F", F);
            validate_non_negative_index("lambda", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> lambda(F, J);
            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda, DUMMY_VAR__);
            stan::math::assign(lambda,lambda_mat(J_f, F_ind, lambda_est, pstream__));
            current_statement_begin__ = 220;
            validate_non_negative_index("lambda_random", "F", F);
            validate_non_negative_index("lambda_random", "J", J);
            validate_non_negative_index("lambda_random", "K", K);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > lambda_random(K, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(F, J));
            stan::math::initialize(lambda_random, DUMMY_VAR__);
            stan::math::fill(lambda_random, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 223;
            for (int k = 1; k <= K; ++k) {
                current_statement_begin__ = 224;
                if (as_bool(eta_cor_nonmi)) {
                    current_statement_begin__ = 225;
                    stan::model::assign(eta_cov_U, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                transpose(diag_pre_multiply(get_base1(eta_sd, k, "eta_sd", 1), convex_combine_Ls(eta_L_fixed, get_base1(eta_L_random, k, "eta_L_random", 1), eta_L_random_weight, pstream__))), 
                                "assigning variable eta_cov_U");
                } else {
                    current_statement_begin__ = 227;
                    stan::model::assign(eta_cov_U, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                transpose(diag_pre_multiply(get_base1(eta_sd, k, "eta_sd", 1), eta_L_fixed)), 
                                "assigning variable eta_cov_U");
                }
            }
            current_statement_begin__ = 230;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 231;
                stan::model::assign(eta, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            add(stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), "eta"), multiply(get_base1(eta_z, n, "eta_z", 1), get_base1(eta_cov_U, get_base1(group, n, "group", 1), "eta_cov_U", 1))), 
                            "assigning variable eta");
            }
            current_statement_begin__ = 235;
            for (int k = 1; k <= K; ++k) {
                current_statement_begin__ = 236;
                stan::model::assign(lambda_random, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            lambda_mat(J_f, F_ind, get_base1(lambda_est_random, k, "lambda_est_random", 1), pstream__), 
                            "assigning variable lambda_random");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 209;
            size_t random_j_1_max__ = K;
            size_t random_j_2_max__ = (total_param + (2 * F));
            for (size_t j_1__ = 0; j_1__ < random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 210;
            size_t lambda_est_random_j_1_max__ = K;
            size_t lambda_est_random_j_2_max__ = total_lambda;
            for (size_t j_1__ = 0; j_1__ < lambda_est_random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < lambda_est_random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(lambda_est_random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: lambda_est_random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_est_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 211;
            size_t resid_random_j_1_max__ = K;
            size_t resid_random_j_2_max__ = J;
            for (size_t j_1__ = 0; j_1__ < resid_random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < resid_random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(resid_random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: resid_random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable resid_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 212;
            size_t nu_random_j_1_max__ = K;
            size_t nu_random_j_2_max__ = J;
            for (size_t j_1__ = 0; j_1__ < nu_random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < nu_random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(nu_random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: nu_random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable nu_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 213;
            size_t eta_mean_j_1_max__ = K;
            size_t eta_mean_j_2_max__ = F;
            for (size_t j_1__ = 0; j_1__ < eta_mean_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < eta_mean_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(eta_mean(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: eta_mean" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_mean: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 214;
            size_t eta_sd_j_1_max__ = K;
            size_t eta_sd_j_2_max__ = F;
            for (size_t j_1__ = 0; j_1__ < eta_sd_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < eta_sd_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(eta_sd(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: eta_sd" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_sd: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 215;
            size_t eta_cov_U_k_0_max__ = K;
            size_t eta_cov_U_j_1_max__ = (2 * F);
            size_t eta_cov_U_j_2_max__ = (2 * F);
            for (size_t k_0__ = 0; k_0__ < eta_cov_U_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < eta_cov_U_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < eta_cov_U_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(eta_cov_U[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: eta_cov_U" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_cov_U: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 216;
            size_t eta_j_1_max__ = N;
            size_t eta_j_2_max__ = F;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(eta(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: eta" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 217;
            size_t lambda_lowerbound_j_1_max__ = total_lambda;
            for (size_t j_1__ = 0; j_1__ < lambda_lowerbound_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lambda_lowerbound(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda_lowerbound" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_lowerbound: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 218;
            size_t lambda_est_j_1_max__ = total_lambda;
            for (size_t j_1__ = 0; j_1__ < lambda_est_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lambda_est(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda_est" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_est: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 219;
            size_t lambda_j_1_max__ = F;
            size_t lambda_j_2_max__ = J;
            for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < lambda_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(lambda(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: lambda" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 220;
            size_t lambda_random_k_0_max__ = K;
            size_t lambda_random_j_1_max__ = F;
            size_t lambda_random_j_2_max__ = J;
            for (size_t k_0__ = 0; k_0__ < lambda_random_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < lambda_random_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < lambda_random_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(lambda_random[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: lambda_random" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            // model body
            {
            current_statement_begin__ = 242;
            validate_non_negative_index("hm_hat", "total_param", total_param);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> hm_hat(total_param);
            stan::math::initialize(hm_hat, DUMMY_VAR__);
            stan::math::fill(hm_hat, DUMMY_VAR__);
            stan::math::assign(hm_hat,stan::math::exp(add(add(add(hm_tau, stan::model::rvalue(hm_param, stan::model::cons_list(stan::model::index_multi(hm_param_index), stan::model::nil_index_list()), "hm_param")), stan::model::rvalue(hm_item, stan::model::cons_list(stan::model::index_multi(hm_item_index), stan::model::nil_index_list()), "hm_item")), hm_lambda)));
            current_statement_begin__ = 243;
            validate_non_negative_index("xhat", "N", N);
            validate_non_negative_index("xhat", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> xhat(N, J);
            stan::math::initialize(xhat, DUMMY_VAR__);
            stan::math::fill(xhat, DUMMY_VAR__);
            stan::math::assign(xhat,add(rep_matrix(nu, N), multiply(eta, lambda)));
            current_statement_begin__ = 244;
            validate_non_negative_index("s_loghat", "N", N);
            validate_non_negative_index("s_loghat", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> s_loghat(N, J);
            stan::math::initialize(s_loghat, DUMMY_VAR__);
            stan::math::fill(s_loghat, DUMMY_VAR__);
            stan::math::assign(s_loghat,rep_matrix(resid_log, N));
            current_statement_begin__ = 246;
            stan::math::assign(xhat, add(xhat, stan::model::rvalue(nu_random, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "nu_random")));
            current_statement_begin__ = 247;
            stan::math::assign(s_loghat, add(s_loghat, stan::model::rvalue(resid_random, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "resid_random")));
            current_statement_begin__ = 248;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 249;
                stan::model::assign(xhat, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            add(stan::model::rvalue(xhat, stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), "xhat"), multiply(get_base1(eta, n, "eta", 1), get_base1(lambda_random, get_base1(group, n, "group", 1), "lambda_random", 1))), 
                            "assigning variable xhat");
            }
            current_statement_begin__ = 253;
            lp_accum__.add(((normal_log(lambda_est, 0, 1) - normal_ccdf_log(lambda_lowerbound, 0, 1)) + sum(lambda_log_est)));
            current_statement_begin__ = 254;
            lp_accum__.add(std_normal_log<propto__>(resid_log));
            current_statement_begin__ = 255;
            lp_accum__.add(normal_log<propto__>(nu, 0, 1));
            current_statement_begin__ = 257;
            lp_accum__.add(std_normal_log<propto__>(to_vector(random_z)));
            current_statement_begin__ = 258;
            lp_accum__.add(lkj_corr_cholesky_log<propto__>(random_L, 1));
            current_statement_begin__ = 259;
            lp_accum__.add(std_normal_log<propto__>(random_sigma));
            current_statement_begin__ = 261;
            lp_accum__.add(std_normal_log<propto__>(to_vector(eta_z)));
            current_statement_begin__ = 262;
            lp_accum__.add(lkj_corr_cholesky_log<propto__>(eta_L_fixed, 1));
            current_statement_begin__ = 263;
            if (as_bool(eta_cor_nonmi)) {
                current_statement_begin__ = 266;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 271;
                    lp_accum__.add(lkj_corr_cholesky_log<propto__>(get_base1(eta_L_random, k, "eta_L_random", 1), (1.0 / get_base1(eta_L_random_weight, 1, "eta_L_random_weight", 1))));
                }
            }
            current_statement_begin__ = 275;
            lp_accum__.add(normal_log<propto__>(hm_tau, hmre_mu, hmre_scale));
            current_statement_begin__ = 276;
            lp_accum__.add(normal_log<propto__>(hm_param, hmre_mu, hmre_scale));
            current_statement_begin__ = 277;
            lp_accum__.add(normal_log<propto__>(hm_item, hmre_mu, hmre_scale));
            current_statement_begin__ = 278;
            lp_accum__.add(normal_log<propto__>(hm_lambda, hmre_mu, hmre_scale));
            current_statement_begin__ = 281;
            lp_accum__.add(normal_log<propto__>(stan::model::rvalue(random_sigma, stan::model::cons_list(stan::model::index_min_max(1, total_param), stan::model::nil_index_list()), "random_sigma"), 0, hm_hat));
            current_statement_begin__ = 284;
            lp_accum__.add(normal_log<propto__>(stan::model::rvalue(random_sigma, stan::model::cons_list(stan::model::index_min_max((total_param + 1), rows(random_sigma)), stan::model::nil_index_list()), "random_sigma"), 0, 1));
            current_statement_begin__ = 286;
            if (as_bool(logical_negation(prior_only))) {
                current_statement_begin__ = 287;
                lp_accum__.add(normal_log<propto__>(x_vector, to_vector(xhat), to_vector(stan::math::exp(s_loghat))));
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("lambda_log_est");
        names__.push_back("nu");
        names__.push_back("resid_log");
        names__.push_back("random_z");
        names__.push_back("random_L");
        names__.push_back("random_sigma");
        names__.push_back("eta_z");
        names__.push_back("eta_L_fixed");
        names__.push_back("eta_L_random");
        names__.push_back("eta_L_random_weight");
        names__.push_back("hm_tau");
        names__.push_back("hm_param");
        names__.push_back("hm_item");
        names__.push_back("hm_lambda");
        names__.push_back("random");
        names__.push_back("lambda_est_random");
        names__.push_back("resid_random");
        names__.push_back("nu_random");
        names__.push_back("eta_mean");
        names__.push_back("eta_sd");
        names__.push_back("eta_cov_U");
        names__.push_back("eta");
        names__.push_back("lambda_lowerbound");
        names__.push_back("lambda_est");
        names__.push_back("lambda");
        names__.push_back("lambda_random");
        names__.push_back("RE_cor");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(total_lambda);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back((total_param + (2 * F)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((total_param + (2 * F)));
        dims__.push_back((total_param + (2 * F)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((total_param + (2 * F)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(F);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * eta_cor_nonmi));
        dims__.push_back(F);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(eta_cor_nonmi);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(total_param);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back((total_param + (2 * F)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(total_lambda);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back((2 * F));
        dims__.push_back((2 * F));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(total_lambda);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(total_lambda);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(F);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(F);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((total_param + (2 * F)));
        dims__.push_back((total_param + (2 * F)));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_redifhm_multi_hier_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, 1, Eigen::Dynamic> lambda_log_est = in__.row_vector_constrain(total_lambda);
        size_t lambda_log_est_j_1_max__ = total_lambda;
        for (size_t j_1__ = 0; j_1__ < lambda_log_est_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_log_est(j_1__));
        }
        Eigen::Matrix<double, 1, Eigen::Dynamic> nu = in__.row_vector_constrain(J);
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            vars__.push_back(nu(j_1__));
        }
        Eigen::Matrix<double, 1, Eigen::Dynamic> resid_log = in__.row_vector_constrain(J);
        size_t resid_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < resid_log_j_1_max__; ++j_1__) {
            vars__.push_back(resid_log(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> random_z = in__.matrix_constrain(K, (total_param + (2 * F)));
        size_t random_z_j_2_max__ = (total_param + (2 * F));
        size_t random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_z_j_1_max__; ++j_1__) {
                vars__.push_back(random_z(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> random_L = in__.cholesky_factor_corr_constrain((total_param + (2 * F)));
        size_t random_L_j_2_max__ = (total_param + (2 * F));
        size_t random_L_j_1_max__ = (total_param + (2 * F));
        for (size_t j_2__ = 0; j_2__ < random_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_L_j_1_max__; ++j_1__) {
                vars__.push_back(random_L(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> random_sigma = in__.vector_lb_constrain(0, (total_param + (2 * F)));
        size_t random_sigma_j_1_max__ = (total_param + (2 * F));
        for (size_t j_1__ = 0; j_1__ < random_sigma_j_1_max__; ++j_1__) {
            vars__.push_back(random_sigma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eta_z = in__.matrix_constrain(N, F);
        size_t eta_z_j_2_max__ = F;
        size_t eta_z_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < eta_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_z_j_1_max__; ++j_1__) {
                vars__.push_back(eta_z(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eta_L_fixed = in__.cholesky_factor_corr_constrain(F);
        size_t eta_L_fixed_j_2_max__ = F;
        size_t eta_L_fixed_j_1_max__ = F;
        for (size_t j_2__ = 0; j_2__ < eta_L_fixed_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_L_fixed_j_1_max__; ++j_1__) {
                vars__.push_back(eta_L_fixed(j_1__, j_2__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > eta_L_random;
        size_t eta_L_random_d_0_max__ = (K * eta_cor_nonmi);
        eta_L_random.reserve(eta_L_random_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < eta_L_random_d_0_max__; ++d_0__) {
            eta_L_random.push_back(in__.cholesky_factor_corr_constrain(F));
        }
        size_t eta_L_random_j_2_max__ = F;
        size_t eta_L_random_j_1_max__ = F;
        size_t eta_L_random_k_0_max__ = (K * eta_cor_nonmi);
        for (size_t j_2__ = 0; j_2__ < eta_L_random_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_L_random_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < eta_L_random_k_0_max__; ++k_0__) {
                    vars__.push_back(eta_L_random[k_0__](j_1__, j_2__));
                }
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta_L_random_weight = in__.vector_lub_constrain(0, 1, eta_cor_nonmi);
        size_t eta_L_random_weight_j_1_max__ = eta_cor_nonmi;
        for (size_t j_1__ = 0; j_1__ < eta_L_random_weight_j_1_max__; ++j_1__) {
            vars__.push_back(eta_L_random_weight(j_1__));
        }
        double hm_tau = in__.scalar_constrain();
        vars__.push_back(hm_tau);
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_param = in__.vector_constrain(3);
        size_t hm_param_j_1_max__ = 3;
        for (size_t j_1__ = 0; j_1__ < hm_param_j_1_max__; ++j_1__) {
            vars__.push_back(hm_param(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_item = in__.vector_constrain(J);
        size_t hm_item_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < hm_item_j_1_max__; ++j_1__) {
            vars__.push_back(hm_item(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_lambda = in__.vector_constrain(total_param);
        size_t hm_lambda_j_1_max__ = total_param;
        for (size_t j_1__ = 0; j_1__ < hm_lambda_j_1_max__; ++j_1__) {
            vars__.push_back(hm_lambda(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 209;
            validate_non_negative_index("random", "K", K);
            validate_non_negative_index("random", "(total_param + (2 * F))", (total_param + (2 * F)));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> random(K, (total_param + (2 * F)));
            stan::math::initialize(random, DUMMY_VAR__);
            stan::math::fill(random, DUMMY_VAR__);
            stan::math::assign(random,z_to_random(random_z, random_sigma, random_L, pstream__));
            current_statement_begin__ = 210;
            validate_non_negative_index("lambda_est_random", "K", K);
            validate_non_negative_index("lambda_est_random", "total_lambda", total_lambda);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> lambda_est_random(K, total_lambda);
            stan::math::initialize(lambda_est_random, DUMMY_VAR__);
            stan::math::fill(lambda_est_random, DUMMY_VAR__);
            stan::math::assign(lambda_est_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(get_base1(get_base1(lamResNu_bounds, 1, "lamResNu_bounds", 1), 1, "lamResNu_bounds", 2), get_base1(get_base1(lamResNu_bounds, 1, "lamResNu_bounds", 1), 2, "lamResNu_bounds", 2)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 211;
            validate_non_negative_index("resid_random", "K", K);
            validate_non_negative_index("resid_random", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> resid_random(K, J);
            stan::math::initialize(resid_random, DUMMY_VAR__);
            stan::math::fill(resid_random, DUMMY_VAR__);
            stan::math::assign(resid_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(get_base1(get_base1(lamResNu_bounds, 2, "lamResNu_bounds", 1), 1, "lamResNu_bounds", 2), get_base1(get_base1(lamResNu_bounds, 2, "lamResNu_bounds", 1), 2, "lamResNu_bounds", 2)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 212;
            validate_non_negative_index("nu_random", "K", K);
            validate_non_negative_index("nu_random", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> nu_random(K, J);
            stan::math::initialize(nu_random, DUMMY_VAR__);
            stan::math::fill(nu_random, DUMMY_VAR__);
            stan::math::assign(nu_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(get_base1(get_base1(lamResNu_bounds, 3, "lamResNu_bounds", 1), 1, "lamResNu_bounds", 2), get_base1(get_base1(lamResNu_bounds, 3, "lamResNu_bounds", 1), 2, "lamResNu_bounds", 2)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 213;
            validate_non_negative_index("eta_mean", "K", K);
            validate_non_negative_index("eta_mean", "F", F);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eta_mean(K, F);
            stan::math::initialize(eta_mean, DUMMY_VAR__);
            stan::math::fill(eta_mean, DUMMY_VAR__);
            stan::math::assign(eta_mean,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max((get_base1(get_base1(lamResNu_bounds, 3, "lamResNu_bounds", 1), 2, "lamResNu_bounds", 2) + 1), (get_base1(get_base1(lamResNu_bounds, 3, "lamResNu_bounds", 1), 2, "lamResNu_bounds", 2) + F)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 214;
            validate_non_negative_index("eta_sd", "K", K);
            validate_non_negative_index("eta_sd", "F", F);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eta_sd(K, F);
            stan::math::initialize(eta_sd, DUMMY_VAR__);
            stan::math::fill(eta_sd, DUMMY_VAR__);
            stan::math::assign(eta_sd,stan::math::exp(stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(((total_param + F) + 1), (total_param + (2 * F))), stan::model::nil_index_list())), "random")));
            current_statement_begin__ = 215;
            validate_non_negative_index("eta_cov_U", "(2 * F)", (2 * F));
            validate_non_negative_index("eta_cov_U", "(2 * F)", (2 * F));
            validate_non_negative_index("eta_cov_U", "K", K);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > eta_cov_U(K, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((2 * F), (2 * F)));
            stan::math::initialize(eta_cov_U, DUMMY_VAR__);
            stan::math::fill(eta_cov_U, DUMMY_VAR__);
            current_statement_begin__ = 216;
            validate_non_negative_index("eta", "N", N);
            validate_non_negative_index("eta", "F", F);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eta(N, F);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            stan::math::assign(eta,stan::model::rvalue(eta_mean, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "eta_mean"));
            current_statement_begin__ = 217;
            validate_non_negative_index("lambda_lowerbound", "total_lambda", total_lambda);
            Eigen::Matrix<double, 1, Eigen::Dynamic> lambda_lowerbound(total_lambda);
            stan::math::initialize(lambda_lowerbound, DUMMY_VAR__);
            stan::math::fill(lambda_lowerbound, DUMMY_VAR__);
            stan::math::assign(lambda_lowerbound,compute_lambda_lowerbounds(lambda_est_random, pstream__));
            current_statement_begin__ = 218;
            validate_non_negative_index("lambda_est", "total_lambda", total_lambda);
            Eigen::Matrix<double, 1, Eigen::Dynamic> lambda_est(total_lambda);
            stan::math::initialize(lambda_est, DUMMY_VAR__);
            stan::math::fill(lambda_est, DUMMY_VAR__);
            stan::math::assign(lambda_est,add(stan::math::exp(lambda_log_est), lambda_lowerbound));
            current_statement_begin__ = 219;
            validate_non_negative_index("lambda", "F", F);
            validate_non_negative_index("lambda", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> lambda(F, J);
            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda, DUMMY_VAR__);
            stan::math::assign(lambda,lambda_mat(J_f, F_ind, lambda_est, pstream__));
            current_statement_begin__ = 220;
            validate_non_negative_index("lambda_random", "F", F);
            validate_non_negative_index("lambda_random", "J", J);
            validate_non_negative_index("lambda_random", "K", K);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > lambda_random(K, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(F, J));
            stan::math::initialize(lambda_random, DUMMY_VAR__);
            stan::math::fill(lambda_random, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 223;
            for (int k = 1; k <= K; ++k) {
                current_statement_begin__ = 224;
                if (as_bool(eta_cor_nonmi)) {
                    current_statement_begin__ = 225;
                    stan::model::assign(eta_cov_U, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                transpose(diag_pre_multiply(get_base1(eta_sd, k, "eta_sd", 1), convex_combine_Ls(eta_L_fixed, get_base1(eta_L_random, k, "eta_L_random", 1), eta_L_random_weight, pstream__))), 
                                "assigning variable eta_cov_U");
                } else {
                    current_statement_begin__ = 227;
                    stan::model::assign(eta_cov_U, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                transpose(diag_pre_multiply(get_base1(eta_sd, k, "eta_sd", 1), eta_L_fixed)), 
                                "assigning variable eta_cov_U");
                }
            }
            current_statement_begin__ = 230;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 231;
                stan::model::assign(eta, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            add(stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), "eta"), multiply(get_base1(eta_z, n, "eta_z", 1), get_base1(eta_cov_U, get_base1(group, n, "group", 1), "eta_cov_U", 1))), 
                            "assigning variable eta");
            }
            current_statement_begin__ = 235;
            for (int k = 1; k <= K; ++k) {
                current_statement_begin__ = 236;
                stan::model::assign(lambda_random, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            lambda_mat(J_f, F_ind, get_base1(lambda_est_random, k, "lambda_est_random", 1), pstream__), 
                            "assigning variable lambda_random");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t random_j_2_max__ = (total_param + (2 * F));
                size_t random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < random_j_1_max__; ++j_1__) {
                        vars__.push_back(random(j_1__, j_2__));
                    }
                }
                size_t lambda_est_random_j_2_max__ = total_lambda;
                size_t lambda_est_random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < lambda_est_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < lambda_est_random_j_1_max__; ++j_1__) {
                        vars__.push_back(lambda_est_random(j_1__, j_2__));
                    }
                }
                size_t resid_random_j_2_max__ = J;
                size_t resid_random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < resid_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < resid_random_j_1_max__; ++j_1__) {
                        vars__.push_back(resid_random(j_1__, j_2__));
                    }
                }
                size_t nu_random_j_2_max__ = J;
                size_t nu_random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < nu_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < nu_random_j_1_max__; ++j_1__) {
                        vars__.push_back(nu_random(j_1__, j_2__));
                    }
                }
                size_t eta_mean_j_2_max__ = F;
                size_t eta_mean_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < eta_mean_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < eta_mean_j_1_max__; ++j_1__) {
                        vars__.push_back(eta_mean(j_1__, j_2__));
                    }
                }
                size_t eta_sd_j_2_max__ = F;
                size_t eta_sd_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < eta_sd_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < eta_sd_j_1_max__; ++j_1__) {
                        vars__.push_back(eta_sd(j_1__, j_2__));
                    }
                }
                size_t eta_cov_U_j_2_max__ = (2 * F);
                size_t eta_cov_U_j_1_max__ = (2 * F);
                size_t eta_cov_U_k_0_max__ = K;
                for (size_t j_2__ = 0; j_2__ < eta_cov_U_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < eta_cov_U_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < eta_cov_U_k_0_max__; ++k_0__) {
                            vars__.push_back(eta_cov_U[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t eta_j_2_max__ = F;
                size_t eta_j_1_max__ = N;
                for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                        vars__.push_back(eta(j_1__, j_2__));
                    }
                }
                size_t lambda_lowerbound_j_1_max__ = total_lambda;
                for (size_t j_1__ = 0; j_1__ < lambda_lowerbound_j_1_max__; ++j_1__) {
                    vars__.push_back(lambda_lowerbound(j_1__));
                }
                size_t lambda_est_j_1_max__ = total_lambda;
                for (size_t j_1__ = 0; j_1__ < lambda_est_j_1_max__; ++j_1__) {
                    vars__.push_back(lambda_est(j_1__));
                }
                size_t lambda_j_2_max__ = J;
                size_t lambda_j_1_max__ = F;
                for (size_t j_2__ = 0; j_2__ < lambda_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                        vars__.push_back(lambda(j_1__, j_2__));
                    }
                }
                size_t lambda_random_j_2_max__ = J;
                size_t lambda_random_j_1_max__ = F;
                size_t lambda_random_k_0_max__ = K;
                for (size_t j_2__ = 0; j_2__ < lambda_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < lambda_random_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < lambda_random_k_0_max__; ++k_0__) {
                            vars__.push_back(lambda_random[k_0__](j_1__, j_2__));
                        }
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 294;
            validate_non_negative_index("RE_cor", "(total_param + (2 * F))", (total_param + (2 * F)));
            validate_non_negative_index("RE_cor", "(total_param + (2 * F))", (total_param + (2 * F)));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> RE_cor((total_param + (2 * F)), (total_param + (2 * F)));
            stan::math::initialize(RE_cor, DUMMY_VAR__);
            stan::math::fill(RE_cor, DUMMY_VAR__);
            stan::math::assign(RE_cor,L_to_cor(random_L, pstream__));
            // validate, write generated quantities
            current_statement_begin__ = 294;
            size_t RE_cor_j_2_max__ = (total_param + (2 * F));
            size_t RE_cor_j_1_max__ = (total_param + (2 * F));
            for (size_t j_2__ = 0; j_2__ < RE_cor_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < RE_cor_j_1_max__; ++j_1__) {
                    vars__.push_back(RE_cor(j_1__, j_2__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_redifhm_multi_hier";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t lambda_log_est_j_1_max__ = total_lambda;
        for (size_t j_1__ = 0; j_1__ < lambda_log_est_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_log_est" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t resid_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < resid_log_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "resid_log" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t random_z_j_2_max__ = (total_param + (2 * F));
        size_t random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_z_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "random_z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t random_L_j_2_max__ = (total_param + (2 * F));
        size_t random_L_j_1_max__ = (total_param + (2 * F));
        for (size_t j_2__ = 0; j_2__ < random_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_L_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "random_L" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t random_sigma_j_1_max__ = (total_param + (2 * F));
        for (size_t j_1__ = 0; j_1__ < random_sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "random_sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_z_j_2_max__ = F;
        size_t eta_z_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < eta_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_z_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t eta_L_fixed_j_2_max__ = F;
        size_t eta_L_fixed_j_1_max__ = F;
        for (size_t j_2__ = 0; j_2__ < eta_L_fixed_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_L_fixed_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_L_fixed" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t eta_L_random_j_2_max__ = F;
        size_t eta_L_random_j_1_max__ = F;
        size_t eta_L_random_k_0_max__ = (K * eta_cor_nonmi);
        for (size_t j_2__ = 0; j_2__ < eta_L_random_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_L_random_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < eta_L_random_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta_L_random" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t eta_L_random_weight_j_1_max__ = eta_cor_nonmi;
        for (size_t j_1__ = 0; j_1__ < eta_L_random_weight_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_L_random_weight" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "hm_tau";
        param_names__.push_back(param_name_stream__.str());
        size_t hm_param_j_1_max__ = 3;
        for (size_t j_1__ = 0; j_1__ < hm_param_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_param" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t hm_item_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < hm_item_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_item" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t hm_lambda_j_1_max__ = total_param;
        for (size_t j_1__ = 0; j_1__ < hm_lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t random_j_2_max__ = (total_param + (2 * F));
            size_t random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t lambda_est_random_j_2_max__ = total_lambda;
            size_t lambda_est_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < lambda_est_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < lambda_est_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "lambda_est_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t resid_random_j_2_max__ = J;
            size_t resid_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < resid_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < resid_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "resid_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t nu_random_j_2_max__ = J;
            size_t nu_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < nu_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < nu_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "nu_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t eta_mean_j_2_max__ = F;
            size_t eta_mean_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < eta_mean_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_mean_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta_mean" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t eta_sd_j_2_max__ = F;
            size_t eta_sd_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < eta_sd_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_sd_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta_sd" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t eta_cov_U_j_2_max__ = (2 * F);
            size_t eta_cov_U_j_1_max__ = (2 * F);
            size_t eta_cov_U_k_0_max__ = K;
            for (size_t j_2__ = 0; j_2__ < eta_cov_U_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_cov_U_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < eta_cov_U_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "eta_cov_U" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t eta_j_2_max__ = F;
            size_t eta_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t lambda_lowerbound_j_1_max__ = total_lambda;
            for (size_t j_1__ = 0; j_1__ < lambda_lowerbound_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_lowerbound" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda_est_j_1_max__ = total_lambda;
            for (size_t j_1__ = 0; j_1__ < lambda_est_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_est" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda_j_2_max__ = J;
            size_t lambda_j_1_max__ = F;
            for (size_t j_2__ = 0; j_2__ < lambda_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "lambda" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t lambda_random_j_2_max__ = J;
            size_t lambda_random_j_1_max__ = F;
            size_t lambda_random_k_0_max__ = K;
            for (size_t j_2__ = 0; j_2__ < lambda_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < lambda_random_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < lambda_random_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "lambda_random" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
        if (!include_gqs__) return;
        size_t RE_cor_j_2_max__ = (total_param + (2 * F));
        size_t RE_cor_j_1_max__ = (total_param + (2 * F));
        for (size_t j_2__ = 0; j_2__ < RE_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < RE_cor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "RE_cor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t lambda_log_est_j_1_max__ = total_lambda;
        for (size_t j_1__ = 0; j_1__ < lambda_log_est_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_log_est" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t resid_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < resid_log_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "resid_log" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t random_z_j_2_max__ = (total_param + (2 * F));
        size_t random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_z_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "random_z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t random_L_j_1_max__ = (((total_param + (2 * F)) * ((total_param + (2 * F)) - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < random_L_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "random_L" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t random_sigma_j_1_max__ = (total_param + (2 * F));
        for (size_t j_1__ = 0; j_1__ < random_sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "random_sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_z_j_2_max__ = F;
        size_t eta_z_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < eta_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_z_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t eta_L_fixed_j_1_max__ = ((F * (F - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < eta_L_fixed_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_L_fixed" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_L_random_j_1_max__ = ((F * (F - 1)) / 2);
        size_t eta_L_random_k_0_max__ = (K * eta_cor_nonmi);
        for (size_t j_1__ = 0; j_1__ < eta_L_random_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < eta_L_random_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_L_random" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t eta_L_random_weight_j_1_max__ = eta_cor_nonmi;
        for (size_t j_1__ = 0; j_1__ < eta_L_random_weight_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_L_random_weight" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "hm_tau";
        param_names__.push_back(param_name_stream__.str());
        size_t hm_param_j_1_max__ = 3;
        for (size_t j_1__ = 0; j_1__ < hm_param_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_param" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t hm_item_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < hm_item_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_item" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t hm_lambda_j_1_max__ = total_param;
        for (size_t j_1__ = 0; j_1__ < hm_lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t random_j_2_max__ = (total_param + (2 * F));
            size_t random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t lambda_est_random_j_2_max__ = total_lambda;
            size_t lambda_est_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < lambda_est_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < lambda_est_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "lambda_est_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t resid_random_j_2_max__ = J;
            size_t resid_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < resid_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < resid_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "resid_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t nu_random_j_2_max__ = J;
            size_t nu_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < nu_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < nu_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "nu_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t eta_mean_j_2_max__ = F;
            size_t eta_mean_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < eta_mean_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_mean_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta_mean" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t eta_sd_j_2_max__ = F;
            size_t eta_sd_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < eta_sd_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_sd_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta_sd" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t eta_cov_U_j_2_max__ = (2 * F);
            size_t eta_cov_U_j_1_max__ = (2 * F);
            size_t eta_cov_U_k_0_max__ = K;
            for (size_t j_2__ = 0; j_2__ < eta_cov_U_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_cov_U_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < eta_cov_U_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "eta_cov_U" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t eta_j_2_max__ = F;
            size_t eta_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t lambda_lowerbound_j_1_max__ = total_lambda;
            for (size_t j_1__ = 0; j_1__ < lambda_lowerbound_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_lowerbound" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda_est_j_1_max__ = total_lambda;
            for (size_t j_1__ = 0; j_1__ < lambda_est_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_est" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda_j_2_max__ = J;
            size_t lambda_j_1_max__ = F;
            for (size_t j_2__ = 0; j_2__ < lambda_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "lambda" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t lambda_random_j_2_max__ = J;
            size_t lambda_random_j_1_max__ = F;
            size_t lambda_random_k_0_max__ = K;
            for (size_t j_2__ = 0; j_2__ < lambda_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < lambda_random_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < lambda_random_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "lambda_random" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
        if (!include_gqs__) return;
        size_t RE_cor_j_2_max__ = (total_param + (2 * F));
        size_t RE_cor_j_1_max__ = (total_param + (2 * F));
        for (size_t j_2__ = 0; j_2__ < RE_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < RE_cor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "RE_cor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_redifhm_multi_hier_namespace::model_redifhm_multi_hier stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
