% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_cop.R
\name{copulaPredict}
\alias{copulaPredict}
\title{Get predictions from a classification model.}
\usage{
copulaPredict(X, model)
}
\arguments{
\item{X}{Data frame with predictor variables.}

\item{model}{Classification model.}
}
\value{
A list with the prediction of the class "class" and the probabilities of each class "prob".
}
\description{
Use the models trained with copula functions
to generate new predictions.
}
\examples{
X <- iris[,1:4]
y <- iris$Species
model <- copulaClassifier(X = X, y = y, copula = "frank",
                      distribution = "kernel", graph_model = "tree")
y_pred <- copulaPredict(X = X, model = model)
table(y,y_pred$class)
#Example 2
X <- iris[,1:4]
y <- iris$Species
model <- copulaClassifier(X = X, y = y, copula = c("frank","clayton"), 
                        distribution = "kernel", graph_model = "chain")
y_pred <- copulaPredict(X = X, model = model)
table(y,y_pred$class)
}
