% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Classification.R
\name{ConfusionDF}
\alias{ConfusionDF}
\title{Confusion Matrix (Data Frame Format)}
\usage{
ConfusionDF(y_true, y_pred)
}
\arguments{
\item{y_true}{Ground truth (correct) labels vector}

\item{y_pred}{Predicted labels vector, as returned by a classifier}
}
\value{
a data.frame of Confusion Matrix
}
\description{
Compute data frame format confusion matrix for internal usage.
}
\examples{
data(cars)
logreg <- glm(formula=vs~hp+wt, family=binomial(link = "logit"), mtcars)
pred <- ifelse(logreg$fitted.values<0.5, 0, 1)
ConfusionDF(y_true=mtcars$vs, y_pred=pred)
}
\keyword{internal}

